@extends('layouts.app')
@section('title', $website_title .' | Termini e Condizioni')
@php( $meta_description = "Leggi i termini e le condizioni di ". $website_title.". I nostri termini spiegano i tuoi diritti, le tue responsabilità e come utilizzare i nostri servizi in modo sicuro ed efficace.")

@section('content')
<div class="terms-and-conditions wf-section">
        <div class="w-container">
            <h1>TERMINI E CONDIZIONI</h1>
            <div>
                <style>
                    table {
                        width: 100%;
                    }
    
                    table,
                    th,
                    td {
                        border: 1px solid;
                        border-collapse: collapse;
                    }
    
                    th,
                    td {
                        padding: 10px;
                    }
    
                    table td {
                        vertical-align: top;
                    }
    
                    .nested-list {
                        counter-reset: item;
                    }
    
                    .nested-list li {
                        display: block;
                    }
    
                    .nested-list li:before {
                        content: counters(item, '.') '. ';
                        counter-increment: item;
                    }
    
                    .legal-section {
                        text-align: left;
                    }
    
                    .legal-section h3 {
                        margin-top: 30px;
                        font-size: 24px;
                    }
    
                    .legal-section h4 {
                        font-size: 18px;
                    }
                </style>
                <p>
                    {{aiTrans('Grazie per aver visitato il nostro')}} <a href="{{ route('home', $country) }}"> sito web</a> {{aiTrans('(il "Sito") dove hai trovato il link per questi Termini e Condizioni (il "Sito"), e la nostra')}} <a href="{{ route('privacy', $country) }}">{{aiTrans('Politica sulla Privacy')}}</a> {{aiTrans('(la "Politica sulla Privacy"). Questo sito web è gestito e controllato da')}} {{ $website_title }}{{aiTrans(' e dalle eventuali società controllanti, filiali o entità correlate, tutte indicate come')}} {{ $website_title }}. {{aiTrans('Il Sito è di nostra proprietà (collettivamente indicato come "noi", "nostro" o "ci") e puoi contattarci in qualsiasi momento via email all\'indirizzo')}}
                    per: <span >info{{ '@'.$website_title }}</span>
                </p>
                <p>
                    {{ aiTrans('Accedendo al Sito o utilizzando i nostri prodotti e/o servizi ("Servizi del Fornitore" e collettivamente con i Servizi di Abbonamento, indicati come "Servizi"), accetti di rispettare questi Termini di Utilizzo ("Termini") e la nostra Politica sulla Privacy. Questi Termini includono regole operative, politiche, informazioni e altri termini supplementari. Ci riserviamo il diritto di modificare i Termini di volta in volta senza preavviso e a nostra discrezione. È tua responsabilità rivedere periodicamente questa pagina per gli aggiornamenti dei Termini, che entreranno in vigore dopo la pubblicazione. Il tuo utilizzo continuato del Sito sarà considerato come accettazione dei Termini.', $locale) }}
                </p>
                <p>
                    {{ aiTrans('Si prega di leggere attentamente i termini completi di questi Termini e Condizioni. Se non sei d\'accordo con una parte di essi, non sei autorizzato a utilizzare i Servizi o il Sito in alcun modo. Ci riserviamo il diritto di negare l\'accesso ai Servizi e/o al Sito a nostra esclusiva discrezione.', $locale) }}
                </p>
                <h3>{{ aiTrans('NESSUNA CONSULENZA DI INVESTIMENTO', $locale) }}</h3>
<p>
    {{ aiTrans('A meno che espressamente dichiarato diversamente, questo sito web non è stato progettato con l\'obiettivo di fornire consulenza finanziaria o di investimento personale. Le informazioni fornite non tengono conto dei tuoi obiettivi di investimento specifici, della tua situazione finanziaria o delle tue necessità di investimento.', $locale) }}
</p>
<p>
    {{ aiTrans('Devi valutare se le informazioni su questo sito web sono adatte ai tuoi obiettivi di investimento, alla tua situazione finanziaria e alle tue necessità di investimento. Devi farlo prima di prendere una decisione di investimento basata sulle informazioni fornite su questo sito web. Puoi fare questa valutazione da solo o cercare assistenza professionale da un consulente finanziario indipendente.', $locale) }}
</p>
<p>
    {{ aiTrans('A meno che espressamente dichiarato diversamente, le informazioni contenute in questo sito web non costituiscono una raccomandazione di investimento in prodotti o servizi finanziari offerti da alcun membro del gruppo di aziende IG.', $locale) }}
</p>
<h3>{{ aiTrans('PRODOTTI E SERVIZI', $locale) }}</h3>
<p>
    {{ aiTrans('Non tutti i prodotti e servizi menzionati su questo sito web sono necessariamente forniti da noi. L\'identificazione o l\'utilizzo di qualsiasi prodotto, servizio, sito web o rete di terzi non costituisce una raccomandazione di tali prodotti, servizi, siti web o reti. Questo sito web può consentire l\'accesso a siti web e reti forniti da persone che non siamo noi tramite un hyperlink o altro link.', $locale) }}
</p>
<p>
    {{ aiTrans('Non accettiamo alcuna responsabilità o obbligo di alcun tipo per qualsiasi materiale su qualsiasi sito web o rete che non sia sotto il nostro controllo diretto. Riconosci che l\'accesso a questi altri siti web o reti tramite tale link potrebbe obbligarci a fornire certe informazioni su di te al proprietario di quel sito web o rete. Nulla su questo sito web è inteso come consulenza di investimento o finanziaria nostra o da parte nostra.', $locale) }}
</p>
<h3>{{ aiTrans('AMBITO E MODIFICA', $locale) }}</h3>
<p>
    {{ aiTrans('Accetti i termini descritti in questo documento riguardo l\'utilizzo del nostro Sito web. Questi Termini costituiscono l\'accordo completo tra te e noi, sostituendo tutti gli accordi, dichiarazioni, garanzie e comprensioni precedenti relative al Sito web.', $locale) }}
</p>
<p>
    {{ aiTrans('Si prega di notare che questi Termini possono essere modificati periodicamente. Se modifichiamo questi Termini, ti informeremo delle opzioni disponibili a seguito di tali modifiche. Inoltre, pubblicheremo un avviso indicando la modifica. L\'uso continuato del Sito web e/o dei nostri Servizi implica la tua totale accettazione di rispettare i termini e le condizioni aggiornati in vigore al momento. È tua responsabilità verificare regolarmente questa pagina per aggiornamenti e/o modifiche.', $locale) }}
</p>
<h3>{{ aiTrans('REQUISITI', $locale) }}</h3>
<p>
    {{ aiTrans('Il Sito web e i nostri Servizi sono disponibili esclusivamente per individui idonei a stipulare contratti legalmente vincolanti secondo la legislazione applicabile. Non sono destinati all\'uso da parte di individui al di sotto dei diciotto (18) anni. Se hai meno di diciotto (18) anni, non sei autorizzato a utilizzare e/o accedere al Sito web e/o ai Servizi.', $locale) }}
</p>
<h3>{{ aiTrans('DESCRIZIONE DEI SERVIZI', $locale) }}</h3>
<p>
    <i>{{ aiTrans('Servizi di Abbonamento:', $locale) }}</i> {{ aiTrans('Registrandoti sul Sito web e ottenendo la nostra approvazione, puoi ottenere, o tentare di ottenere, Servizi di Abbonamento a pagamento o gratuiti. Questi servizi forniscono contenuti via email, SMS e altri materiali ("Contenuti di Abbonamento") pertinenti al marketing online da parte nostra e di partner terzi ("Fornitori Terzi"). Questo non è consulenza di investimento. Comprendi e accetti che non siamo responsabili per l\'accuratezza, la completezza o l\'adeguatezza del Contenuto di Abbonamento.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Servizi del Fornitore e Terzi:', $locale) }}</i> {{ aiTrans('Compilando i moduli di registrazione, puoi ottenere, o tentare di ottenere, determinati prodotti e/o servizi dal Sito web. Le descrizioni di prodotti e/o servizi nel Sito web possono essere fornite dai Fornitori Terzi. Non garantiamo l\'accuratezza o la completezza di tali descrizioni. Comprendi e accetti che non siamo responsabili per l\'incapacità di ottenere prodotti e/o servizi dal Sito web o dai suoi partner affiliati, né per qualsiasi controversia con i venditori di prodotti, distributori o fornitori terzi con cui potresti interagire in relazione al sito web.', $locale) }}
</p>
<p>
    <i>{{ aiTrans('Generale:', $locale) }}</i> {{ aiTrans('Per utilizzare i Servizi, devi fornire dati di Registrazione accurati, e ci riserviamo il diritto di rifiutare dati incompleti, fraudolenti o inaccettabili. A meno che espressamente indicato diversamente, qualsiasi offerta futura che migliori le funzionalità del Sito web sarà soggetta a questi Termini. Accetti che non siamo responsabili per la tua incapacità di utilizzare e/o qualificarti per i Servizi e per qualsiasi modifica, sospensione o cessazione.', $locale) }}
</p>
<h3>{{ aiTrans('DIRITTI DI PROPRIETÀ', $locale) }}</h3>
<p>
    {{ aiTrans('Il Sito web, il Contenuto e i Servizi, inclusi organizzazione, grafica, design, compilazione, software e altre questioni, sono protetti da diritti d\'autore, marchi registrati e altri diritti di proprietà applicabili. La riproduzione, redistribuzione o vendita di qualsiasi parte del Sito web, Contenuto e/o Servizi è severamente vietata. Il recupero di materiale tramite mezzi automatizzati o scraping per qualsiasi scopo senza permesso scritto è vietato. Non acquisisci diritti di proprietà su alcun contenuto, documento, software, servizi o materiali nel Sito web. Il nostro nome, logo, grafica, icone e nomi dei servizi sono marchi registrati. L\'uso non autorizzato di qualsiasi marchio registrato è severamente vietato.', $locale) }}
</p>
<h3>{{ aiTrans('INFORMAZIONI CONFIDENZIALI', $locale) }}</h3>
<p>
    {{ aiTrans('Le informazioni confidenziali si riferiscono a informazioni proprietarie identificate come tali e non includono informazioni di dominio pubblico, conoscenze preesistenti, informazioni sviluppate in modo indipendente o informazioni ricevute da terzi senza restrizioni di divulgazione. L\'obbligo di proteggere le informazioni confidenziali scade un (1) anno dopo la cessazione.', $locale) }}
</p>
<h3>{{ aiTrans('DIVIETO DI LINK AL SITO WEB, CO-BRANDING, "FRAMING" E/O RIFERIMENTO AL SITO WEB', $locale) }}</h3>
<p>
    {{ aiTrans('I link al Sito web o a sue parti su un altro sito web senza la nostra espressa autorizzazione sono vietati. Il "framing" del Sito web o il riferimento all\'Uniform Resource Locator ("URL") senza il nostro permesso scritto è severamente vietato. La cooperazione per rimuovere tale contenuto o attività è obbligatoria, e sei responsabile per qualsiasi danno associato.', $locale) }}
</p>
<h3>{{ aiTrans('MODIFICA, ELIMINAZIONE E MODIFICA', $locale) }}</h3>
<p>
    {{ aiTrans('Ci riserviamo il diritto di modificare e/o eliminare qualsiasi documento, informazione o contenuto nel Sito web senza preavviso.', $locale) }}
</p>
<h3>{{ aiTrans('ESCLUSIONE DI RESPONSABILITÀ', $locale) }}</h3>
<p>
    {{ aiTrans('Il Sito web, i Servizi, il Contenuto e qualsiasi prodotto di terzi sono forniti "COSÌ COME SONO" E "COME DISPONIBILE", CON TUTTE LE GARANZIE, ESPRESSE E IMPLICITE, ESCLUSE NELLA MASSIMA MISURA CONSENTITA DALLA LEGGE APPLICABILE. NON GARANTIAMO CHE IL SITO WEB, I SERVIZI, IL CONTENUTO E/O I PRODOTTI DI TERZI SODDISFERANNO LE TUE ESIGENZE O SARANNO ININTERROTTI, OPORTUNI, SICURI O SENZA ERRORI. CONVIENI CHE NON SIAMO RESPONSABILI PER QUALSIASI RECLAMO RELATIVO ALL\'INCREDIBILITÀ DI UTILIZZARE IL SITO WEB, I SERVIZI, IL CONTENUTO E/O I PRODOTTI DI TERZI. IL SITO WEB PUÒ CONTENERE ERRORI, MALFUNZIONAMENTI O LIMITAZIONI, E NON SIAMO RESPONSABILI PER LA DISPONIBILITÀ DELLA CONNESSIONE INTERNET.', $locale) }}
</p>
<h3>{{ aiTrans('LIMITAZIONE DI RESPONSABILITÀ', $locale) }}</h3>
<p>
    {{ aiTrans('NON SIAMO RESPONSABILI PER DANNI DIRETTI, INDIRETTI, INCIDENTALI, SPECIALI O ESEMPLARI, INCLUSI LA PERDITA DI PROFITTI, BUONA VOLONTÀ, USO, DATI O ALTRE PERDITE INTANGIBILI. QUESTA LIMITAZIONE SI APPLICA A TUTTE LE CAUSE DI AZIONE, INCLUSI VIOLAZIONE DI CONTRATTO, GARANZIA, NEGLIGENZA, RESPONSABILITÀ OGGETTIVA, DICHIARAZIONI FALSE E QUALSIASI ALTRO REATO. CI LIBERI E LIBERI I NOSTRI FORNITORI TERZI DA OBBLIGHI, RESPONSABILITÀ E RECLAMI OLTRE LA LIMITAZIONE INDICATA. SE LA LEGGE APPLICABILE NON CONSENTE QUESTA LIMITAZIONE, LA NOSTRA RESPONSABILITÀ MASSIMA IN QUALSIASI CIRCOSTANZA SARÀ DI CINQUECENTO DOLLARI (500,00 USD).', $locale) }}
</p>
<h3>{{ aiTrans('INDENNIZZO', $locale) }}</h3>
<p>
    {{ aiTrans('Accetti di indennizzarci e esentarci, i nostri partner, filiali, affiliate e i rispettivi membri, direttori, dipendenti, agenti e partner da qualsiasi reclamo, spesa, danno, causa legale, costo, richiesta e/o sentenza avanzata da terzi derivante o risultante dal tuo uso del Sito web, Servizi o Contenuto; dalla tua violazione di questi Termini; e/o dalla tua violazione dei diritti di un altro individuo e/o entità.', $locale) }}
</p>
<h3>{{ aiTrans('SITI WEB DI TERZI', $locale) }}</h3>
<p>
    {{ aiTrans('Il Sito web può fornire link a altri siti web e/o risorse Internet appartenenti a Fornitori Terzi. Non siamo responsabili per la disponibilità di tali siti web e/o risorse di terzi, né per i loro contenuti, e non approviamo né ci assumiamo alcuna responsabilità per i loro termini, politiche sulla privacy, contenuti, pubblicità, servizi, prodotti o materiali.', $locale) }}
</p>
<h3>{{ aiTrans('POLITICA SULLA PRIVACY/INFORMAZIONI DEI VISITATORI', $locale) }}</h3>
<p>
    {{ aiTrans('L\'uso del Sito web e tutti i commenti, feedback, informazioni, dati di registrazione e/o materiali inviati sono soggetti alla nostra Politica sulla Privacy. Ci riserviamo il diritto di utilizzare informazioni sul tuo utilizzo del Sito web e informazioni personali identificabili secondo la nostra Politica sulla Privacy e le leggi sulla protezione dei dati applicabili.', $locale) }}
</p>
<h3>{{ aiTrans('AVVISO LEGALE', $locale) }}</h3>
<p>
    {{ aiTrans('Qualsiasi tentativo di danneggiare, distruggere, alterare, vandalizzare o interferire con l\'operazione del Sito web è una violazione della legge penale e civile. Cercheremo di ottenere risorse contro qualsiasi individuo o entità violatrice nella massima estensione consentita dalla legge e dall\'equità.', $locale) }}
</p>
<h3>{{ aiTrans('SCELTA DELLA LEGGE E FORO COMPETENTE', $locale) }}</h3>
<p>
    {{ aiTrans('Questi Termini sono regolati e interpretati in conformità con le leggi del Regno Unito. Le Parti cercheranno di negoziare un accordo di buona fede per qualsiasi reclamo o disputa derivante o relativa a questi Termini e Condizioni in modo amichevole. Se le Parti non raggiungono un accordo, la disputa sarà sottoposta esclusivamente a procedimenti di arbitrato riservato davanti a un unico arbitro a Londra, secondo le regole dell\'ICC, la cui sentenza sarà finale e vincolante. Nessuna parte deve presentare una richiesta al tribunale locale del suo domicilio o qualsiasi altro foro.', $locale) }}
</p>
<h3>{{ aiTrans('ALLEGATO SULLA PROTEZIONE DEI DATI', $locale) }}</h3>
<p>
    {{ aiTrans('Questo Allegato sulla Protezione dei Dati fa parte dei nostri Termini e Condizioni. I termini utilizzati qui hanno significati specificati in questo Allegato. Salvo quanto modificato di seguito, i Termini rimangono in pieno vigore ed efficacia.', $locale) }}
</p>
<ol class="nested-list">
    <li>
        <b>{{ aiTrans('Definizioni', $locale) }}</b>
        <ol class="nested-list">
            <li>
                <b>{{ aiTrans('Leggi Applicabili:', $locale) }}</b> {{ aiTrans('Leggi dell\'UE o dello Stato Membro relative ai Dati Personali soggetti alle Leggi sulla Protezione dei Dati dell\'UE e altre leggi applicabili per i Dati Personali soggetti ad altre Leggi sulla Protezione dei Dati.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Titolare del Trattamento:', $locale) }}</b> {{ aiTrans('Entità che determina le finalità e i mezzi di trattamento dei Dati Personali.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Leggi sulla Protezione dei Dati:', $locale) }}</b> {{ aiTrans('Leggi sulla Protezione dei Dati dell\'UE e leggi sulla protezione dei dati o privacy di qualsiasi altro paese.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('Leggi sulla Protezione dei Dati dell\'UE:', $locale) }}</b> {{ aiTrans('Direttiva 95/46/CE dell\'UE, GDPR e leggi correlate.', $locale) }}
            </li>
            <li>
                <b>{{ aiTrans('GDPR:', $locale) }}</b> {{ aiTrans('Regolamento Generale sulla Protezione dei Dati dell\'UE 2016/679.', $locale) }}
            </li>
        </ol>
    </li>
    <li>
        <b>{{ aiTrans('Raccolta e Trattamento dei Dati Personali', $locale) }}</b>
<ol class="nested-list">
    <li>
        {{ aiTrans('Ci impegniamo a rispettare tutte le leggi sulla protezione dei dati applicabili nel trattamento dei Dati Personali.', $locale) }}
        <ol class="nested-list">
            <li>
                {{ aiTrans('Dichiariamo e garantiamo di avere le necessarie autorizzazioni e consensi dai titolari dei dati per consentire legalmente la raccolta, il trattamento e la condivisione dei Dati Personali tramite i Servizi in conformità con le Leggi Applicabili.', $locale) }}
            </li>
            <li>
                {{ aiTrans('Mantenere un meccanismo per ottenere e ritirare il consenso, in conformità con le Leggi Applicabili, e una politica sulla privacy pubblicamente disponibile.', $locale) }}
            </li>
            <li>
                {{ aiTrans('Riconosciamo di non fornire Servizi a bambini di età inferiore ai diciotto (18) anni.', $locale) }}
            </li>
        </ol>
    </li>
</ol>
</li>
<li>
    <b>{{ aiTrans('Sicurezza', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Implementeremo misure tecniche e organizzative adeguate per la sicurezza dei dati in conformità con l\'Articolo 32(1) del GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Sub-processamento', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Ci autorizzi a nominare Sub-processori e garantire che i contratti scritti con i Sub-processori offrano lo stesso livello di protezione per i Dati Personali come descritto in questo Allegato e soddisfino i requisiti del GDPR.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Diritti dei Titolari dei Dati', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Aiuteremo a rispondere alle richieste dei diritti dei Titolari dei Dati in conformità con le leggi sulla protezione dei dati, considerando la natura del trattamento.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Violazione dei Dati Personali', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Informeremo immediatamente i Titolari dei Dati interessati non appena veniamo a conoscenza di una Violazione dei Dati Personali, assistendo nell\'indagine, mitigazione e rimedio.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Termini Generali', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Le controversie o i reclami derivanti da questi Termini sono soggetti alla giurisdizione stabilita qui. Se una disposizione è invalida, il resto rimarrà valido.', $locale) }}
        </li>
    </ol>
</li>
<li>
    <b>{{ aiTrans('Modifiche', $locale) }}</b>
    <ol class="nested-list">
        <li>
            {{ aiTrans('Le modifiche a questi Termini possono essere apportate di volta in volta a nostra esclusiva discrezione', $locale) }}
        </li>
    </ol>
</li>
<p>
    {{aiTrans('Accettando questi Termini e Condizioni, riconosci di aver letto, compreso
    e accetti di essere vincolato da tutti i termini descritti sopra. Il tuo utilizzo continuato del Sito web
    e dei Servizi costituisce accettazione di questi termini. Se hai domande o preoccupazioni,
    contattaci all\'indirizzo')}} <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>




            </div>
        </div>
    </div>
@endsection
