<?php

use Codebase\PageBuilder\Http\Controllers\StaticPageController;

Route::
    prefix('static-pages')
    ->as('static-pages.')
    ->group(function () {
        Route::get('/', [StaticPageController::class, 'index'])->name('index');
        Route::get('/create', [StaticPageController::class, 'create'])->name('create');
        Route::Post('/create', [StaticPageController::class, 'store'])->name('store');

        Route::get('/{staticPage}', [StaticPageController::class, 'show'])->name('show');
        Route::get('/{staticPage}/edit', [StaticPageController::class, 'edit'])->name('edit');
        Route::put('/{staticPage}', [StaticPageController::class, 'update'])->name('update');
        Route::post('/editable-page/{page}', [StaticPageController::class, 'editablePage'])
        ->name('editable-pages.store');

        Route::delete('/{staticPage}/delete', [StaticPageController::class, 'destroy'])->name('destroy');

        Route::post('/media/upload', [StaticPageController::class, 'uploadMedia'])
            ->name('media.upload');

    });
