<?php

namespace Codebase\PageBuilder\Database\Seeders;

use Codebase\PageBuilder\Models\StaticPage;
use Illuminate\Database\Seeder;

class StaticPageSeeder extends Seeder
{
    public function run()
    {
        foreach ($this->pages() as $page) {
            StaticPage::updateOrCreate(['key' => $page['key']], $page);
        }
    }

    private function pages()
    {
        return [
            [
                'key' => 'privacy-policy',
                'name' => ["ar" => "سياسة الخصوصية", "en" => 'Privacy Policy'],
                'template_id' => 'default',
                'main_page' => true,

            ],
            [
                'key' => 'terms-and-conditions',
                'name' => ["ar" => "الأحكام والشروط", "en" => 'Terms and Conditions'],
                'template_id' => 'default',
                'main_page' => true,

            ],

            [
                'key' => 'home',
                'name' => ["en" => "Home page", "ar" => 'الصفحة الرئيسية'],
                'template_id' => 'default',
                'main_page' => true,
                'is_section' => false,
            ],
            [
                'key' => 'about-us',
                'name' => ["ar" => "من نحن", "en" => 'About us'],
                'template_id' => 'default',
                'main_page' => true,
                'is_section' => false,
            ],
            [
                'key' => 'contact-us',
                'name' => ["en" => "Contact us", "ar" => 'تواصل معنا'],
                'template_id' => 'default',
                'main_page' => true,
                'is_section' => false,
            ],
        ];
    }
}
