<?php

use Carbon\Carbon;
use Illuminate\Support\Str;
use Collective\Html\FormFacade;
use App\Domain\Core\Models\Country;
use Illuminate\Support\Facades\Log;
use App\Domain\Company\Models\Chart;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Route;
use App\Domain\Core\Models\Placeholder;
use Illuminate\Support\Facades\Storage;
use App\Domain\User\Actions\UserCartAction;
use Stichoza\GoogleTranslate\GoogleTranslate;
use App\Domain\User\Actions\GetTotalPriceOrders;
if (!function_exists('formatCount')) {
    function formatCount($count)
    {
        if ($count >= 1000000) {
            return round($count / 1000000, 1) . __('M');
        } elseif ($count >= 1000) {
            return round($count / 1000, 1) . __('K');
        }

        return $count;
    }
}
if (!function_exists('getErrorMessage')) {
    function getErrorMessage($errorCode, $locale = 'en') {
        return trans("messages.$errorCode", [], $locale);
    }
}
if (!function_exists('countryLanguageMapping')) {
    /**
     * Map countries to their respective languages.
     *
     * @return array
     */
    function countryLanguageMapping()
    {
        return [
            // Arabic-speaking countries
            'eg' => 'ar', 'sa' => 'ar', 'ae' => 'ar', 'dz' => 'ar', 'bh' => 'ar',
            'dj' => 'ar', 'jo' => 'ar', 'iq' => 'ar', 'kw' => 'ar', 'lb' => 'ar',
            'ly' => 'ar', 'ma' => 'ar', 'mr' => 'ar', 'om' => 'ar', 'ps' => 'ar',
            'qa' => 'ar', 'sd' => 'ar', 'so' => 'ar', 'sy' => 'ar', 'tn' => 'ar', 'ye' => 'ar',
            // English-speaking countries
            'us' => 'en', 'gb' => 'en', 'ca' => 'en', 'au' => 'en', 'nz' => 'en',
            'ie' => 'en', 'jm' => 'en', 'tt' => 'en', 'bb' => 'en', 'za' => 'en',
            'ng' => 'en', 'gh' => 'en', 'ke' => 'en', 'ug' => 'en', 'zw' => 'en',
            // Czech
            'cz' => 'cs',
            //'cs' => 'cs',
            // Danish
            'dk' => 'da',
            // German
            'de' => 'de',
            // Spanish
            'es' => 'es', 'mx' => 'es', 'ar' => 'es', 'cl' => 'es', 'co' => 'es',
            // Finnish
            'fi' => 'fi',
            // French-speaking countries
            'fr' => 'fr', 'be' => 'fr', 'ch' => 'fr', 'cm' => 'fr', 'ci' => 'fr',
            'dj' => 'fr', 'ga' => 'fr', 'gn' => 'fr', 'ml' => 'fr', 'mc' => 'fr',
            'ne' => 'fr', 'sn' => 'fr', 'td' => 'fr', 'tg' => 'fr',
            // Greek
            'el' => 'el',
            // Croatian
            'hr' => 'hr',
            // Hungarian
            'hu' => 'hu',
            // Indonesian
            'id' => 'id',
            // Icelandic
            'is' => 'is',
            // Italian
            'it' => 'it',
            // Japanese
            'jp' => 'ja',
            // Korean
            'kr' => 'ko',
            // Dutch
            'nl' => 'nl',
            // Norwegian
            'no' => 'no',
            // Filipino
            'fil' => 'fil',
            // Polish
            'pl' => 'pl',
            // Portuguese
            'pt' => 'pt', 'br' => 'pt',
            // Romanian
            'ro' => 'ro',
            // Russian
            'ru' => 'ru',
            // Slovak
            'sk' => 'sk',
            'hi' => 'hi',
            // Swedish
            'se' => 'sv',
            // Turkish
            'tr' => 'tr',
            // Chinese
            'cn' => 'zh', 'hk' => 'zh', 'tw' => 'zh',
        ];
    }
}

if (!function_exists('convertToelegory')) {
    function convertToelegory($date)
    {
        $date = Carbon::createFromFormat('d/m/Y', $date)
            ->format('d-m-Y');
        return Hijrian::elegory($date)->format('Y-m-d');
    }
}
if (!function_exists('convertToHijry')) {
    function convertToHijry($date)
    {
        return $date != null ? Hijrian::hijri($date)->format('d/m/Y') : null;
    }
}
if (!function_exists('phone_from_array')) {
    function phone_from_array(array $requestData): string
    {
        return rescue(function () use ($requestData) {
            return phone($requestData['phone'], $requestData['country_code'])->formatE164();
        }, $requestData['phone'] ?? '', false);
    }
}
if (!function_exists('langs')) {

    function langs()
    {
        return [
            'en', // English
            'fr', // French
            'es', // Spanish
            'ar', // Arabic
            'ru', // Russian
            'zh', // Chinese (Mandarin)
            'hi', // Hindi
            'za', // africia
            'pt', // Portuguese
            'fil', // Portuguese
            'it', // Italian
            'ja', // Japanese
            'nl', // Dutch
            'sv', // Swedish
            'hr', // Croatian
            'no', // Norwegian
            'fi', // Finnish
            'da', // Danish
            'ko', // Korean
            'el', // Korean
            'de', // Korean
            'th', // Thai
            'tr', // Turkish
            'pl', // Polish
            'cs', // Czech
            'sk', // Slovak
            'he', // Hebrew
            'hu', // Hungarian
            'ro', // Romanian
            'bg', // Bulgarian
            'uk', // Ukrainian
            'vi', // Vietnamese
            'ms', // Malay
            'id', // Indonesian
            'is', // Indonesian
            'fa', // Persian (Farsi)
            'ta', // Tamil
            'ur', // Urdu
            'bn', // Bengali
            'pa', // Punjabi
            'et', // Punjabi
            'my', // Burmese
            'en-ca', // Burmese
            'km', // Khmer
            'lo', // Lao
        ];
    }

}
if (!function_exists('googleTrans')) {

    function googleTrans($key, $locale, $placeholders = [])
    {
        $normalizedKey = trim(strtolower($key));
        $cacheKey = "googleTrans_" . md5($normalizedKey) . "_{$locale}";
        $lockKey = "lock_googleTrans_" . md5($normalizedKey) . "_{$locale}";

        // Check if the translation is already cached
        if (Cache::has($cacheKey)) {
            // Return the cached translation immediately
            return Cache::get($cacheKey);
        }

        // Acquire a lock to prevent multiple users from triggering the same API call
        $lock = Cache::lock($lockKey, 30); // Set a timeout for the lock, e.g., 30 seconds

        if ($lock->get()) {
            try {
                // Cache miss, so fetch the translation from the API
                $translatedText = GoogleTranslate::trans($key, $locale);

                // Replace placeholders with actual values after translation
                foreach ($placeholders as $placeholder => $value) {
                    $translatedText = str_replace("[$placeholder]", $value, $translatedText);
                }

                // Store the translation in the cache for future use
                Cache::put($cacheKey, $translatedText, now()->addYear(10));

                // Release the lock
                $lock->release();

                // Return the translated text to the first user
                return $translatedText;
            } catch (\Exception $e) {
                // Ensure the lock is released if an error occurs
                $lock->release();
                throw $e;
            }
        } else {
            // If the lock is held by another request, wait until the translation is cached
            return Cache::get($cacheKey, $key); // Return untranslated text as fallback while waiting
        }
    }
}

if (!function_exists('countryLang')) {
    /**
     * Get the language for a given country code.
     *
     * @param string $countryCode
     * @return string
     */
    function countryLang($countryCode) {
        // Get the mapping of country codes to languages
        $countryLanguages = countryLangMapping();

        // Return the language if the country code exists in the mapping
        return $countryLanguages[$countryCode] ?? 'en'; // Default to 'en' if country code not found
    }
}
if (!function_exists('countryLangMapping')) {
    /**
     * Mapping of countries to their default languages.
     *
     * @return array
     */
    function countryLangMapping() {
        return [
            'en' => 'en', // English (default for English-speaking countries)
            'fr' => 'fr', // French (for France and other French-speaking countries)
            'ru' => 'ru', // Russian
            'hr' => 'hr', // Croatian
            'de' => 'de', // German
            'es' => 'es', // Spanish
            'ar' => 'ar', // Arabic
            'zh' => 'zh', // Chinese (Mandarin)
            'hi' => 'hi', // Hindi
            'pt' => 'pt', // Portuguese
            'fil' => 'tl', // Filipino/Tagalog (for the Philippines)
            'it' => 'it', // Italian
            'ja' => 'ja', // Japanese
            'nl' => 'nl', // Dutch
            'sv' => 'sv', // Swedish
            'no' => 'no', // Norwegian
            'fi' => 'fi', // Finnish
            'da' => 'da', // Danish
            'ko' => 'ko', // Korean
            'th' => 'th', // Thai
            'tr' => 'tr', // Turkish
            'pl' => 'pl', // Polish
            'cs' => 'cs', // Czech
            'sk' => 'sk', // Slovak
            'el' => 'el', // eleek
            'he' => 'he', // Hebrew
            'hu' => 'hu', // Hungarian
            'ro' => 'ro', // Romanian
            'bg' => 'bg', // Bulgarian
            'uk' => 'uk', // Ukrainian
            'vi' => 'vi', // Vietnamese
            'ms' => 'ms', // Malay
            'id' => 'id', // Indonesian
            'is' => 'is', // Icelandic
            'fa' => 'fa', // Persian (Farsi)
            'ta' => 'ta', // Tamil
            'ur' => 'ur', // Urdu
            'bn' => 'bn', // Bengali
            'pa' => 'pa', // Punjabi
            'my' => 'my', // Burmese
            'km' => 'km', // Khmer
            'lo' => 'lo', // Lao
            'et' => 'et', // Estonian
            'el'=>'ka'
        ];
    }
}

if (!function_exists('countryRedirectOnError')) {
    /**
     * Get the language for a given country code.
     *
     * @param string $countryCode
     * @return string
     */
    function countryRedirectOnError($countryCode) {
        // Get the mapping of country codes to languages
        $countryRedirects = countryRedirectMapping();

        // Return the language if the country code exists in the mapping
        return $countryRedirects[$countryCode] ?? 'Thank-you/en.html'; // Default to 'en' if country code not found
    }
}

if (!function_exists('countryRedirectMapping')) {
    /**
     * Mapping of countries to their default languages.
     *
     * @return array
     */
    function countryRedirectMapping() {
        return [
            'ar' => 'Thank-you/ar.html',
            'cs' => 'Thank-you/cs.html',
            'da' => 'Thank-you/da.html',
            'de' => 'Thank-you/de.html',
            'en' => 'Thank-you/en.html',
            'es' => 'Thank-you/es.html',
            'fi' =>  'Thank-you/fi.html',
            'fr' => 'Thank-you/fr.html',
            'el' => 'Thank-you/el.html',
            'hr' => 'Thank-you/hr.html',
            'hu' => 'Thank-you/hu.html',
            'id' => 'Thank-you/id.html',
            'is' => 'Thank-you/is.html',
            'it' => 'Thank-you/it.html',
            'ja' => 'Thank-you/ja.html',
            'ko' => 'Thank-you/ko.html',
            'nl' => 'Thank-you/nl.html',
            'no' => 'Thank-you/no.html',
            'fil' => 'Thank-you/fil.html',
            'pl' => 'Thank-you/pl.html',
            'pt' => 'Thank-you/pt.html',
            'ro' => 'Thank-you/ro.html',
            'ru' => 'Thank-you/ru.html',
            'sk' => 'Thank-you/sk.html',
            'sv' => 'Thank-you/sv.html',
            'tr' => 'Thank-you/tr.html',
            'zh' => 'Thank-you/zh.html',
            'hi' => 'Thank-you/hi.html',

        ];
    }
}
if (!function_exists('aiTrans')) {

    function aiTrans($key, $locale =null, $placeholders = [])
    {

        $locale = $locale ?? session('locale','en'); // Get the first segment as the country
        // Get the country from the route or request
        $country = request()->route('country') ?? 'en';

        // Mapping of countries to their default languages
        $countryLanguages = countryLangMapping();
        // Check if the country matches the locale and if translation is needed
        if ($country !== null && isset($countryLanguages[$country]) && $countryLanguages[$country] === $locale) {
            foreach ($placeholders as $placeholder => $value) {
                $key = str_replace("[$placeholder]", $value, $key);
            }
            return $key;
        }

        $normalizedKey = trim(strtolower($key));
        $translatedText = $key;
        // Cache key includes both locale and country to differentiate translations by country
        $cacheKey = "googleTrans_{$locale}_{$country}_". md5($normalizedKey) ;
        $lockKey = "lock_googleTrans_{$locale}_{$country}_". md5($normalizedKey) ;
        // Replace the placeholders with actual values
        foreach ($placeholders as $placeholder => $value) {
            $translatedText = str_replace("[$placeholder]", $value, $translatedText);
        }

        return $translatedText;  // Return only the translation string
        // Check if the translation is already cached
        if (Cache::has($cacheKey)) {
            // Get the cached data
            $cachedData = Cache::get($cacheKey);

            // Ensure we're only returning the 'translation' key, not the entire array
            if (isset($cachedData['translation'])) {
                $translatedText = $cachedData['translation'];

                // Replace the placeholders with actual values
                foreach ($placeholders as $placeholder => $value) {
                    $translatedText = str_replace("[$placeholder]", $value, $translatedText);
                }

                return $translatedText;  // Return only the translation string
            }
        }

        // Acquire a lock to prevent multiple users from triggering the same API call
        $lock = Cache::lock($lockKey, 200);

        if ($lock->get()) {
            try {
                // Replace placeholders with unique tokens to prevent translation
                $tokens = [];
                foreach ($placeholders as $placeholder => $value) {
                    $token = '__' . strtoupper($placeholder) . '__';  // Create a unique token
                    $tokens[$token] = "[$placeholder]";  // Store the token-to-placeholder map
                    $key = str_replace("[$placeholder]", $token, $key);  // Replace the placeholder with token
                }

                // Call OpenAI service to translate the text with tokens
                $translatedText = (new \App\Services\OpenAITranslationService())->translate($key, $locale);

                // After translation, replace the tokens back with the original placeholders
                foreach ($tokens as $token => $placeholder) {
                    $translatedText = str_replace($token, $placeholder, $translatedText);
                }

                // Release the lock
                $lock->release();
                // Replace the placeholders with actual values before returning
                foreach ($placeholders as $placeholder => $value) {
                    $translatedText = str_replace("[$placeholder]", $value, $translatedText);
                }
                // Store the metadata in the cache
                $cacheData = [
                    'translation' => $translatedText,
                    'locale' => $locale,
                    'country' => $country,
                ];

                // Store the translation with metadata in the cache
                Cache::put($cacheKey, $cacheData, now()->addYear(10));
                return $translatedText;  // Return only the translation string
            } catch (\Exception $e) {
                $lock->release();
                throw $e;
            }
        } else {
            // If the lock is held by another request, wait until the translation is cached
            $translatedText = Cache::get($cacheKey)['translation'] ?? $key;

            // Replace the placeholders with actual values
            foreach ($placeholders as $placeholder => $value) {
                $translatedText = str_replace("[$placeholder]", $value, $translatedText);
            }

            return $translatedText;  // Return only the translation string
        }
    }

}


if (!function_exists('getPlaceholder')) {
    function getPlaceholder($key)
    {
        $placeholder = Placeholder::where('name', $key)->first();
        if ($placeholder) {
            return $placeholder->value;
        }

        return 'Telephone, e.g.  0100 123 4567';
    }
}

if(!function_exists('getCountryByLang')){
    function getCountryByLang($lang){
        // Mapping of countries to their default languages
        $countryLanguages = [
            'en' => 'English', // English (default for English-speaking countries)
            'fr' => 'French', // French (for France and other French-speaking countries)
            'ru' => 'Russian', // Russian
            'hr' => 'Croatian', // Russian
            'de' => 'German', // German
            'es' => 'Spanish', // Spanish
            'ar' => 'Arabic', // Arabic
            'zh' => 'Chinese', // Chinese (Mandarin)
            'hi' => 'Hindi', // Hindi
            'pt' => 'Portuguese', // Portuguese
            'fil' => 'fil', // Portuguese
            'it' => 'Italian', // Italian
            'ja' => 'Japanese', // Japanese
            'nl' => 'Dutch', // Dutch
            'sv' => 'Swedish', // Swedish
            'no' => 'Norwegian', // Norwegian
            'fi' => 'Finnish', // Finnish
            'da' => 'Danish', // Danish
            'ko' => 'Korean', // Korean
            'th' => 'Thai', // Thai
            'tr' => 'Turkish', // Turkish
            'pl' => 'Polish', // Polish
            'cs' => 'Czech', // Czech
            'sk' => 'Slovak', // Slovak
            'el' => 'Greek', // Greek
            'he' => 'Hebrew', // Hebrew
            'hu' => 'Hungarian', // Hungarian
            'ro' => 'Romanian', // Romanian
            'bg' => 'Bulgarian', // Bulgarian
            'uk' => 'Ukrainian', // Ukrainian
            'vi' => 'Vietnamese', // Vietnamese
            'ms' => 'Malay', // Malay
            'id' => 'Indonesian', // Indonesian
            'is' => 'Islanda', // Indonesian
            'fa' => 'Persian', // Persian (Farsi)
            'ta' => 'Tamil', // Tamil
            'ur' => 'Urdu', // Urdu
            'bn' => 'Bengali', // Bengali
            'pa' => 'Punjabi', // Punjabi
            'my' => 'Burmese', // Burmese
            'km' => 'Khmer', // Khmer
            'lo' => 'Lao', // Lao
            'et' => 'Estonian', // Estonian
            // Add more countries and their default languages as needed
        ];
        return $countryLanguages[$lang];

    }
}



if (!function_exists('setting')) {

    function setting($key, $default = null, $autoLag = false)
    {
        if (is_null($key)) {
            return \App\Domain\Core\Models\Setting::pluck('val', 'name');
        }

        if (is_array($key)) {
            return \App\Domain\Core\Models\Setting::set($key[0], $key[1]);
        }

        $value = ($autoLag) ? \App\Domain\Core\Models\Setting::get($key . '_' . app()->getLocale()) : \App\Domain\Core\Models\Setting::get($key);

        return is_null($value) ? value($default) : $value;
    }
}
if (!function_exists('cart_count')) {
    function cart_count()
    {
        return (new UserCartAction())->count();
    }
}
if (!function_exists('GetTotalPriceOrders')) {
    function GetTotalPriceOrders()
    {
        return (new GetTotalPriceOrders())();
    }
}

if (!function_exists('getaddress')) {
    function getaddress($lat, $lng, $type = 'address')
    {
        $url = 'https://maps.googleapis.com/maps/api/geocode/json?latlng=' . trim($lat) . ',' . trim($lng) . '&sensor=false&key=' . env('GOOGLE_MAP_KEY') . '&language=' . app()->getLocale() . '';
        $json = @file_get_contents($url);
        $data = json_decode($json);

        $status = $data->status;

        if ($status == "OK") {
            if ($type == 'address') {
                return $data->results[0]->formatted_address;
            } else {
                return $data->results[3]->address_components[3] ?? $data->results[3]->address_components[2];
            }

        } else {
            return false;
        }
    }
}

if (!function_exists('load_countries')) {
    function load_countries($select = null, $dep_hide = null)
    {

        $countries = Country::get();

        $dep_arr = [];
        $states = [
            'success',
            'info',
            'danger',
            'warning',
        ];

        foreach ($countries as $country) {
            $list_arr = [];

            $list_arr['icon'] = (rand(0, 3) == 2 ? 'fa fa-file icon-lg' : 'fa fa-folder icon-lg')
                . 'text' . ($states[rand(0, 3)]);

            if (is_array($select)) {
                if (in_array($country->id, $select)) {
                    $list_arr['state'] = [
                        'opened' => false,
                        'selected' => true,
                        'disabled' => false,
                    ];
                }
            } else {
                if ($select !== null and $select == $country->id) {
                    $list_arr['state'] = [
                        'opened' => false,
                        'selected' => true,
                        'disabled' => false,
                    ];
                }
            }

            if ($dep_hide !== null and $dep_hide == $country->id) {
                $list_arr['state'] = [
                    'opened' => false,
                    'selected' => false,
                    'disabled' => true,
                    'hidden' => true,
                ];
            }

            $list_arr['id'] = $country->id;
            if ($country->states) {
                foreach ($country->states as $state) {
                    $list_arr['children'][] =
                        [
                            'icon' => (rand(0, 3) == 2 ? 'fa fa-file icon-lg' : 'fa fa-folder icon-lg')
                                . 'text' . ($states[rand(0, 3)]),
                            'id' => 'state-' . $state->id,
                            'text' => $state->getTranslation('name', app()->getLocale()),
                            'state' => [
                                'opened' => false,
                                'selected' => false,
                                'disabled' => false,
                            ],
                        ];
                }
            }

            //$list_arr['parent'] = $department->country? $department->country : '#';
            $list_arr['text'] = $country->getTranslation('name', app()->getLocale());
            array_push($dep_arr, $list_arr);
        }

        return json_encode($dep_arr, JSON_UNESCAPED_UNICODE);
    }
}
if (!function_exists('dotted_string')) {
    function dotted_string(string $name): string
    {
        if ($name === '') {
            return $name;
        }

        $base = str_replace(['[', ']'], ['.', ''], $name);
        if ($base[strlen($base) - 1] === '.') {
            return substr($base, 0, -1);
        }

        return $base;
    }
}
if (!function_exists('toMap')) {
    function toMap(Traversable $iterator, string $key = 'id', string $value = 'name'): array
    {
        $result = [];
        foreach ($iterator as $item) {
            $result[$item[$key]] = $item[$value];
        }

        return $result;
    }
}
if (!function_exists('theme_path')) {
    function theme_path(string $path): string
    {
        return base_path('packages/HsmFawaz/UI/' . $path);
    }
}
if (!function_exists('locale_field')) {
    function locale_field(string $name, $locale = 'ar'): ?string
    {
        if ($model = FormFacade::getModel()) {
            return $model->getTranslation($name, $locale);
        }

        return null;
    }
}
if (!function_exists('route_group')) {
    function route_group(string|array $prefix, callable $callback): void
    {
        $prefixValue = is_array($prefix) ? $prefix['prefix'] : $prefix;
        $as = Str::of($prefixValue)->snake()->lower()->append('.');
        $namespace = Str::of($prefixValue)->singular()->studly();
        $middleware = [];

        if (is_array($prefix)) {
            $as = $prefix['as'] ?? $as;
            $namespace = $prefix['namespace'] ?? $namespace;
            $middleware = $prefix['middleware'] ?? $middleware;
        }

        Route::group([
            'prefix' => $prefixValue,
            'as' => $as,
            'namespace' => $namespace,
            'middleware' => $middleware,
        ], $callback);
    }
}

if (!function_exists('app_settings')) {
    function app_settings()
    {
        return json_decode(Storage::disk('local')->get("application/app-settings.json"), true);
    }
}

if (!function_exists('load_organizational_chart')) {
    function load_organizational_chart($select = null, $dep_hide = null)
    {
        $chartsQ = Chart::query()->with(['children', 'parent'])->withCount(['children', 'parent'])->selectRaw('name as name')
            ->selectRaw('id as id');

        $Charts = $chartsQ->get(['text', 'parent', 'id', 'type']);

        $dep_arr = [];
        $states = [
            'success',
            'info',
            'danger',
            'warning',
        ];

        foreach ($Charts as $Chart) {
            $list_arr = [];
            $list_arr['icon'] = ($Chart->children_count == 0 ? 'fa fa-calendar icon-lg' : 'fa fa-calendar icon-lg')
                . 'text' . ($states[rand(0, 3)]);


            $list_arr['id'] = $Chart->id;
            $list_arr['parent'] = $Chart?->parent != null ? $Chart?->parent->id : '#';
            $list_arr['text'] = $Chart->getTranslation('name', app()->getLocale());
            $list_arr['model'] = get_class($Chart);
            $list_arr['li_attr'] = [
                'edit_href' => route('dashboard.company.charts.edit', ['chart' => $Chart->id]),
                'delete_href' => route('dashboard.company.charts.destroy', ['chart' => $Chart->id]),
                'redirect' => false];

            array_push($dep_arr, $list_arr);


        }

        $list_arr = [];
        $list_arr['id'] = "createChart";
        $list_arr['parent'] = "#";
        $list_arr['icon'] = 'fa fa-plus icon-lg';
        $list_arr['text'] = trans('Create Chart');
        $list_arr['li_attr'] = ['href' => route('dashboard.company.charts.create'), 'redirect' => true];

        array_push($dep_arr, $list_arr);
        // dd(json_encode($dep_arr, JSON_UNESCAPED_UNICODE));
        return json_encode($dep_arr, JSON_UNESCAPED_UNICODE);
    }


    if (!function_exists('append_to_translate_json')) {

        function append_to_translate_json($key, $locale)
        {
            if ($locale == 'en') {
                return;
            }
            $available_trans_model = ['auth', 'pagination', 'passwords', 'validation'];
            $keyParts = explode('.', $key);
            $firstKeyParameter = $keyParts[0];

            if (in_array($firstKeyParameter, $available_trans_model)) {
                // First key parameter is in $available_trans_model array
                return;
            }
            $jsonPath = resource_path('lang/' . $locale . '.json');

            // Check if the file exists
            if (!File::exists($jsonPath)) {
                // Create an empty array for the new JSON file
                $emptyArray = [];

                // Convert the array to JSON
                $emptyJsonString = json_encode($emptyArray, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

                // Save the JSON to the file
                File::put($jsonPath, $emptyJsonString);
            }

            // Read the existing JSON file
            $jsonString = File::get($jsonPath);
            $array = json_decode($jsonString, true);

            // Append the new key to the array
            $array[$key] = '';

            // Convert the array back to JSON
            $updatedJsonString = json_encode($array, JSON_UNESCAPED_UNICODE | JSON_PRETTY_PRINT);

            // Save the updated JSON back to the file
            File::put($jsonPath, $updatedJsonString);
        }

    }
}
