<?php

namespace App\Support\Dashboard\Crud;

use Illuminate\Database\Eloquent\Model;

trait WithDestroy
{
    protected function destroyAction(Model $model)
    {
        $model->delete();

        return null;
    }

    public function destroy($id)
    {
        $model = ($this->model)::findOrFail($id);
        $action = $this->destroyAction($model);

        return $action ?? $this->successfulRequest(asJson: true);
    }

    public function multiDestroy()
    {
        if (is_array(request('item'))) {
            foreach (request('item') as $id) {
                $model = ($this->model)::findOrFail($id);
                $this->destroyAction($model);
            }
        } else {
            $model = ($this->model)::findOrFail(request('item'));
            $this->destroyAction($model);
        }

        return $action ?? $this->successfulRequest(asJson: false);
    }


}
