<?php

namespace App\Http\Resources\API\User;

use App\Http\Resources\API\Core\AreaResource;
use App\Http\Resources\API\Core\CityResource;
use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class UserResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'first_name' => $this->first_name,
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'city' => new CityResource($this->city),
            'area' => new AreaResource($this->area),
            'role' => $this->roles()->first()?->name,
            'is_broker' => (boolean)$this->is_broker,
            'company_id' => (integer)$this->company_id,
            'address' => $this->address,
            'lat' => $this->lat,
            'lng' => $this->lng,
            'balance' => $this->balance,
            'avatar' => $this->getFirstMediaUrl('avatar'),
            'license_image' => $this->getFirstMediaUrl('license_image'),
            'identification_image' => $this->getFirstMediaUrl('identification_image'),
        ];
    }

}
