<?php $__env->startSection('title', $website_title .' | Personvernpolitikk'); ?>
<?php ( $meta_description = "Finn ut hvordan ". $website_title." beskytter dine personlige data. Vår personvernpolitikk detaljerer tiltakene vi tar for å sikre sikkerheten og åpenheten i informasjonen din."); ?>

<?php $__env->startSection('content'); ?>
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>PERSONVERNPOUTIKK</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3><?php echo e(aiTrans('1. Introduksjon', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Denne erklæringen beskriver personvernpolitikken som følges av', $locale)); ?> <?php echo e($website_title); ?> ("<?php echo e(aiTrans('vi', $locale)); ?>," "<?php echo e(aiTrans('vår', $locale)); ?>," "<?php echo e(aiTrans('eller', $locale)); ?>")
    <?php echo e(aiTrans('angående våre produkter og tjenester (de "Tjenestene") og', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('nettside', $locale)); ?></a>
    <?php echo e(aiTrans('("Nettside")', $locale)); ?>. <?php echo e(aiTrans('Å beskytte ditt personvern og konfidensialiteten til informasjonen din er avgjørende for oss når vi tilbyr våre Tjenester og drifter Nettsiden.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Våre Tjenester og Nettside kan inneholde lenker til nettsteder og tjenester fra tredjeparter. Vi er ikke ansvarlige for personvernpraksisen til disse tredjepartene. Vi anbefaler at du gjennomgår deres personvernpolitikk før du bruker dem.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('All informasjon som vi mottar i forbindelse med våre Tjenester behandles som konfidensiell. Vi benytter robuste tekniske, sikkerhetsmessige og organisatoriske tiltak for å beskytte Personopplysninger (som definert nedenfor) mot uautorisert behandling, tilfeldig tap, ødeleggelse, skade, tyveri eller utlevering.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Når du sender informasjonen din via vårt nettsted, kan du bli bedt om å oppgi personopplysninger som ditt navn, e-post, telefonnummer, fødselsdato og diverse identifikasjonsdetaljer. Denne informasjonen kan brukes, blant annet, for å verifisere identiteten, administrere informasjon, tilby teknisk støtte og oppfylle kontrakts- og lovpålagte forpliktelser. Vi kan kommunisere viktige detaljer gjennom varsler, og med ditt samtykke, gi informasjon om produkter og tjenester via SMS, e-post, etc. Du har muligheten til å administrere varslingspreferanser og melde deg av bestemte kommunikasjoner.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('2. Nettside; Besøkende og Brukere', $locale)); ?></h3>
<h4><?php echo e(aiTrans('2.1. Generelt', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Denne seksjonen beskriver spesifikasjonene for innsamling av data fra ulike grupper: besøkende på nettstedet ("Besøkende"), brukere ("Brukere") og forretningspartnere (samlet "Partnere"). Personopplysninger inkluderer IP-adresse, navn, kontaktinformasjon og informasjon om forholdet til oss, som definert av gjeldende personvernforskrifter.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.2. Innsamling og Bruk', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Ved å besøke Nettsiden gir du ditt samtykke til innsamling og bruk av dine Personopplysninger. Manglende samtykke til disse vilkårene bør hindre deg i å besøke Nettsiden. Vi kan samle inn informasjon gjennom sidevisningsaktivitet, IP-adresser og informasjonskapsler. Videre behandler vi data som frivillig er gitt via skjemaer og registreringer.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.3. Formål med Behandling av Personopplysninger', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi behandler Personopplysninger for å forbedre, forstå og tilpasse vår Nettside og Tjenester. Dette inkluderer å forbedre nøyaktigheten, kommunikasjon om Tjenester, støtte, kontraktsforpliktelser og samarbeid med partnere. Samtykke eller et rettslig grunnlag er essensielt for all behandling.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('Følgende beskriver formålene og det rettslige grunnlaget for behandlingen av Personopplysninger:', $locale)); ?></p>
<table>
    <tbody>
        <tr>
            <td><?php echo e(aiTrans('Registrering som kontoinnehaver', $locale)); ?></td>
            <td><?php echo e(aiTrans('Ditt samtykke; Utførelse av Tjenester eller kontraktsforpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Tilby og bruk Tjenester', $locale)); ?></td>
            <td><?php echo e(aiTrans('Utførelse av Tjenester eller kontraktsforpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Operasjonelle oppdateringer', $locale)); ?></td>
            <td><?php echo e(aiTrans('Utførelse av Tjenester eller kontraktsforpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Svare på forespørsler og tilby støtte', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser eller utførelse av Tjenester', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Tjenester, reklame og tilpasset markedsføring', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser eller ditt samtykke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Forbedring og tilbud om nye Tjenester', $locale)); ?></td>
            <td><?php echo e(aiTrans('Samtykke og legitime interesser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Sending av reklame- og markedsføringsmateriell', $locale)); ?></td>
            <td><?php echo e(aiTrans('Ditt samtykke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analyse av markedsføringskampanjer', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser eller samtykke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Utførelse av forskjellige støtteaktiviteter', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser eller utførelse av Tjenester', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analyse, inkludert statistisk analyse', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Beskytte interesser, rettigheter og eiendom', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitime interesser eller lovpålagte forpliktelser', $locale)); ?></td>
        </tr>
    </tbody>
</table>
<h4><?php echo e(aiTrans('2.4. Deling av Personopplysninger', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi kan dele informasjon med tjenesteleverandører, Partnere og kontraktspartnere. For Besøkende og Brukere i Det Europeiske Økonomiske Området, skjer behandling av data i samsvar med GDPR og gjeldende personvernlovgivning.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('3. Partnere', $locale)); ?></h3>
<h4><?php echo e(aiTrans('3.1. Generelt', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('For å tilby Tjenester og samarbeide med Partnere, samler vi inn og behandler spesifikke datatyper. Partnere er ansvarlige for sine egne data, og vi kan få tilgang til dem via sikre metoder.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.2. Behandling av Personopplysninger', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi er avhengige av samtykke fra Partnere eller deres legitime interesser for å behandle Personopplysninger. Dataaggregater kan opprettes for utvikling og forbedring av kvaliteten.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.3. Kontrollør/Behandler', $locale)); ?></h4>
<p><?php echo e(aiTrans('Vi kan fungere som Kontrollør eller Behandler, avhengig av hvilken type data:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Besøkende/Brukerdata: Kontrollør', $locale)); ?></li>
    <li><?php echo e(aiTrans('Partnerdata: Behandler', $locale)); ?></li>
    <li><?php echo e(aiTrans('Alle data er trygt vert med høyeste sikkerhetsstandarder. Vi implementerer fysiske, tekniske og organisatoriske beskyttelsestiltak.', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('3.4. Beskyttelse av Tredjeparts Data', $locale)); ?></h4>
<p><?php echo e(aiTrans('Hvis Tjenestene involverer behandling av Personopplysninger på en tredjeparts plattform:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Vi fungerer som Behandler', $locale)); ?></li>
    <li><?php echo e(aiTrans('Følge tredjeparts instruksjoner', $locale)); ?></li>
    <li><?php echo e(aiTrans('Implementere sikkerhetstiltak', $locale)); ?></li>
    <li><?php echo e(aiTrans('Informere om datainnbrudd', $locale)); ?></li>
    <li><?php echo e(aiTrans('Ikke underbehandle uten samtykke', $locale)); ?></li>
    <li><?php echo e(aiTrans('Ikke behandle data utenfor Det Europeiske Økonomiske Området uten samtykke', $locale)); ?></li>
    <li><?php echo e(aiTrans('For elektronisk markedsføring, garanterer vi samtykke og avmeldingsalternativer.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('4. Sikkerhet', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Vi benytter administrative, organisatoriske og tekniske beskyttelsestiltak for å beskytte Personopplysninger mot uautorisert tilgang, avsløring, endring, tap, misbruk eller skade. Når vi deler data med tredjepart, sørger vi for at de opprettholder samme beskyttelsesstandarder, og vi etablerer kontraktsforpliktelser for eksklusiv og sikker behandling, i samsvar med denne politikken.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Dersom det er mistanke om at interaksjonen med oss har blitt kompromittert, bør Besøkende, Brukere eller Partnere informere oss umiddelbart. Det er viktig å merke seg at til tross for våre sikkerhetstiltak, kan vi ikke garantere fullstendig immunitet mot angrep fra tredjepart. Brukerne erkjenner de iboende risikoene og mulige bruddene.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('5. Informasjonskapsler', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Se vår', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('Cookie-policy', $locale)); ?></a> <?php echo e(aiTrans('for detaljerte opplysninger om hvilke typer informasjonskapsler og sporingsmekanismer som brukes på Nettsiden, formålet med bruken, og hvordan du kan godta eller avvise dem.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('6. Lenker til Andre Nettsteder', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Under navigasjonen på Nettsiden kan Brukerne finne lenker til eksterne nettsteder som er utenfor vår kontroll. Vi tar ikke ansvar for innholdet eller personvernpraksisene til disse nettstedene. Brukerne anbefales å gjennomgå personvernpolicyene til slike nettsteder og tredjepartstjenester før de deler Personopplysninger.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('7. Oppbevaring og Sletting', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Data, inkludert Personopplysninger, vil ikke bli oppbevart lenger enn nødvendig. Besøkende og/eller Brukere med aktive kontoer er ansvarlige for rettidig sletting av data. Etter at en konto eller partnerskap er avsluttet, vil Personopplysninger samlet gjennom Nettsiden og/eller Tjenestene bli slettet i samsvar med gjeldende lover og våre interne policyer.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Tilbaketrekking av samtykke for behandling av Personopplysninger kan begrense tilgangen til noen eller alle forespurte Tjenester, uten at det kan fremsettes krav eller motstand.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('8. Dine Rettigheter', $locale)); ?></h3>
<p><?php echo e(aiTrans('Brukere har spesifikke rettigheter angående deres Personopplysninger:', $locale)); ?></p>
<h4><?php echo e(aiTrans('8.1. Rett til Tilgang', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Bekrefte om Personopplysninger behandles', $locale)); ?></li>
    <li><?php echo e(aiTrans('Få tilgang til Personopplysninger og relaterte informasjoner', $locale)); ?></li>
    <li><?php echo e(aiTrans('Informasjon om formålene med behandlingen, kategorier, mottakere, lagringstid, rettigheter og eksistens av profiler', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.2. Rett til Rettelse', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Rette unøyaktige Personopplysninger', $locale)); ?></li>
    <li><?php echo e(aiTrans('Fullføre ufullstendige Personopplysninger', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.3. Rett til Sletting', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Be om sletting av Personopplysninger under spesifikke omstendigheter', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.4. Rett til Å Begrense Behandling', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Få behandling begrenset under spesifikke omstendigheter', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.5. Rett til Dataportabilitet', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Motta Personopplysninger i et strukturert, maskinlesbart format', $locale)); ?></li>
    <li><?php echo e(aiTrans('Overføre Personopplysninger til en annen kontrollør', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.6. Rett til Å Protestere', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Protestere mot behandling basert på legitime interesser eller direkte markedsføring', $locale)); ?></li>
    <li><?php echo e(aiTrans('Stoppe behandlingen, med mindre det finnes overbevisende og/eller juridiske grunner for det', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.7. Rett til Å Trekke Tilbake Samtykke', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Trekke tilbake samtykke for behandling av Personopplysninger når som helst', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('9. Reklame- og Markedsføringsmateriale', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Samtykke innhentes for bruk av Personopplysninger og kontaktinformasjon for å sende reklame- og markedsføringsmateriale. Tilbaketrekking av samtykke er mulig ved å sende et skriftlig varsel til den oppgitte e-postadressen.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('10. Aksept av Denne Politikken', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Ved å bruke Nettsiden og/eller Tjenestene, anses Besøkende, Brukere og/eller Partnere å ha lest og godtatt denne Politikken. Enhver uenighet innebærer avholdelse fra å bruke plattformen. Vi forbeholder oss retten til å endre Politikken, og Brukere oppfordres til å sjekke oppdateringer regelmessig. Fortsatt bruk etter endringer innebærer aksept.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('11. Lovpålagt Utlevering av Personopplysninger', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Personopplysninger kan utleveres uten forhåndssamtykke dersom det er grunn til å etablere identitet, kontakte eller iverksette rettslige prosedyrer mot personer som mistenkes for å ha krenket rettigheter eller eiendom. Utlevering vil skje når det kreves av loven.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('12. Personvernombud', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('For spørsmål om personvern og databeskyttelse, kan en utpekt "Personvernombud" kontaktes på e-postadressen', $locale)); ?> <span >info<?php echo e('@'.$website_title); ?></span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/newcccone/public_html/immediatenew.com/resources/views/frontend/no/privacy.blade.php ENDPATH**/ ?>