@extends('layouts.app')
@section('title', $website_title .' | BİZE ULAŞIN')
@php( $meta_description = "Bizimle iletişime geçin, ". $website_title." ekibi burada! Kripto para ticaretinde deneyiminizle ilgili sorularınızı yanıtlamak ve destek sağlamak için buradayız.")

@section('content')
<div class="contact w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/contact-img.webp" sizes="(max-width: 991px) 100vw, 50vw"  alt="{{ $website_title }} - Bize Ulaşın" class="img-float-right max-width-50-percent contact-image">
    <div class="container w-container">
        <h1>{{aiTrans('Bize Ulaşın')}}</h1>
        <div class="contact-form-warp">
            <div class="w-form-wrapper">
                <form data-name="" action="" method="post" id="email-form" name="email-form" class="contact-form" data-wf-page-id="62f100d8551494f3d8716116" data-wf-element-id="5b923abc-fcd6-8970-5604-5bab15c5eede" novalidate="novalidate">
                    <div class="contact-cell">
                        <div class="email-and-name w-row">
                            <div class="name-col w-col w-col-6">
                                <div class="form-group">
                                    <input type="text" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[name]" data-name="FunnelContactForm[name]" placeholder="Adınızı girin">
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                            <div class="email-col w-col w-col-6">
                                <div class="form-group">
                                    <input type="email" class="form-control control-bordered w-input" maxlength="256" name="FunnelContactForm[email]" data-name="FunnelContactForm[email]" placeholder="E-posta adresinizi girin">
                                    <div class="warning-icon"></div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="contact-cell">
                        <div class="form-group">
                            <textarea placeholder="Mesajınızı yazın..." maxlength="5000" data-name="FunnelContactForm[message]" name="FunnelContactForm[message]" id="field" class="form-control textarea w-input"></textarea>
                            <div class="warning-icon"></div>
                        </div>
                    </div>
                    <div class="text-center-2"><button type="submit" data-wait="Lütfen bekleyin..." class="button w-button">Mesajı Gönder</button></div>
                </form>
                <div class="w-form-done">
                    <div>{{aiTrans('Teşekkür ederiz! Gönderiniz alındı!')}}</div>
                </div>
                <div class="w-form-fail">
                    <div>{{aiTrans('Hups! Formu gönderirken bir şeyler yanlış gitti.')}}</div>
                </div>
            </div>
        </div>
    </div>
    <div class="contact-bg-1"></div>
</div>
    @push('css')
        <style>
            /* Başarı mesajı için özel CSS */
            .success-message {
                background-color: #d4edda;
                color: #155724;
                padding: 15px;
                border: 1px solid #c3e6cb;
                border-radius: 5px;
                margin-bottom: 20px;
            }

            /* Mesajı varsayılan olarak gizle */
            .d-none {
                display: none;
            }

            /* Özel buton stili */
            .btn-submit {
                background-color: #28a745; /* Özel yeşil renk */
                color: white;
                padding: 10px 20px;
                border: none;
                border-radius: 5px;
                cursor: pointer;
                font-size: 18px;
            }

            .btn-submit:hover {
                background-color: #218838; /* Üzerine gelindiğinde daha koyu yeşil */
            }

            /* Temel form stili */
            .form-group input, .form-group textarea {
                width: 100%;
                padding: 10px;
                border: 1px solid #ccc;
                border-radius: 5px;
            }

        </style>
    @endpush
    @push('js')
        <script>
            document.getElementById('contactForm').addEventListener('submit', function(event) {
                event.preventDefault(); // Geleneksel form gönderimini engelle

                // Form gönderimini simüle et
                setTimeout(function() {
                    // Başarı mesajını göster
                    document.getElementById('successMessage').classList.remove('d-none');

                    // İsteğe bağlı olarak, form alanlarını temizle
                    document.getElementById('contactForm').reset();
                }, 500); // Sunucu yanıt gecikmesini simüle et
            });
        </script>
    @endpush
@endsection
