@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Revolucioniranje trgovanja kriptovalutama: predstavljamo najnovije ažuriranje [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Revolucioniranje trgovanja kriptovalutama: predstavljamo najnovije ažuriranje {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.hr.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Hvala vam! Vaša prijava je zaprimljena!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Ups! Nešto je pošlo po zlu prilikom slanja obrasca.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Što je {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Što je [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "S ponosom najavljujemo lansiranje nove verzije [website_title] – ultimativne platforme za trgovanje kriptovalutama. S naprednim značajkama, vrhunskom tehnologijom i korisnički prilagođenim sučeljem, novi [website_title] dizajniran je za podizanje vašeg trgovačkog iskustva na višu razinu. Moćan i intuitivan softver za trgovanje može iskoristiti male razlike u cijenama digitalnih valuta između različitih burzi. Zatim će kupiti kriptovalute po niskoj cijeni i kasnije ih prodati po višoj cijeni. Krajnji rezultat su mali profiti koji se akumuliraju u velike dobitke za korisnika.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Registrirajte se sada")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Kako započeti s trgovanjem online?')}}</h2>
        <div class="trading-text">{{aiTrans('Online trgovanje, osnovna kupnja i prodaja financijskih sredstava putem interneta, može se obavljati gotovo bilo tko, bez obzira na prethodno iskustvo na globalnim financijskim tržištima. Iako je lako započeti, ako želite biti profitabilni, online trgovanje može biti izazov. Da biste započeli s trgovanjem online, trebat će vam računalo i pouzdana internetska veza. Nakon što se registrirate za trgovački račun na renomiranoj platformi, moći ćete započeti trgovanje čim vaš račun bude aktiviran i financiran. Zanimljivo je da, iako je lako započeti trgovanje, puno je teže uspjeti kao trgovac. Postoji mnoštvo rizika kojih morate biti svjesni. Veliki dio trgovanja uključuje metodičko planiranje, preciznu analizu tržišta, razumijevanje čimbenika koji utječu na cijene sredstava, kao i pokušaje i pogreške. Neka tržišta sredstava također mogu biti prilično volatilna, što može povećati rizik od gubitaka ako nemate potrebne vještine za iskorištavanje brojnih profitabilnih prilika koje volatilnost može ponuditi. Unatoč izazovima, s tehnološkim napretkom u algoritamskoj tehnologiji, ovaj tip trgovačkog softvera učinio je lakšim nego ikada započeti online trgovanje s većom preciznošću. Algoritam aplikacije analizirat će tržišta kako bi identificirao prilike za trgovanje, a s tim informacijama moći ćete donositi pametnije trgovačke odluke na temelju analize tržišta. Na ovaj način čak i početnici mogu započeti trgovanje svojim omiljenim sredstvima online.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Registrirajte se sada")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - Je li {{$website_title}} prijevara?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "Je li [website_title] prijevara?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <p class="not-scam-text">
            {{ aiTrans(
                "Ne, nije. [website_title] ne obećava zajamčene profite od trgovanja kriptovalutama jer nije automatizirani trgovački softver. Aplikacija je samo trgovački asistent. Dizajnirana je kako bi pomogla investitorima da trguju kriptovalutama s povjerenjem. Aplikacija pruža stvarne podatke u stvarnom vremenu kako bi pomogla trgovcima da donesu brze i točne odluke prilikom trgovanja svojim omiljenim kriptovalutama online. Osim toga, aplikacija je sigurna i ne ugrožava osobne ili financijske podatke svojih korisnika.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper">
            <a href="#formTop" class="button white w-button">{{aiTrans("REGISTRIRAJTE SE SADA")}}</a>
        </div>
    </div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Kako aplikacija {{$website_title}} poboljšava vaše trgovanje?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Kako aplikacija [website_title] poboljšava vaše trgovanje?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Nije važno koju razinu vještine imate u online trgovanju, moći ćete iskoristiti moćne značajke trgovanja koje nudi aplikacija [website_title]. Međutim, prvo morate razumjeti kako softver funkcionira. [website_title] može analizirati tržišta pomoću visoko sofisticiranog algoritma koji uključuje velike količine tržišnih podataka, kao i nekoliko važnih tehničkih indikatora za identificiranje trgovačkih postavki s visokim izgledima za uspjeh. Također ćete moći prilagoditi parametre u intuitivnom dizajnerskom sučelju softvera. Samo prilagodite način rada softvera prema vlastitoj razini vještine, toleranciji na rizik i preferencijama. Softver omogućuje čak i početnicima da započnu trgovanje na tržištima bez brige o tome hoće li pogriješiti prilikom analize tržišnih kretanja i određivanja trenutka za ulazak u trgovinu. Osim toga, još jedna velika prednost je ta što, kako napredujete kao trgovac, možda ćete htjeti preuzeti praktičniji pristup. U toj situaciji, softver i dalje može biti vrlo koristan za potvrdu vaše vlastite tržišne analize prije nego što uđete u trgovinu. Čak i na višoj razini vještine, mogli biste se naći u situacijama kada ste previše nervozni ili uzbuđeni da biste donosili logične trgovačke odluke. U tom slučaju, možete koristiti tržišnu analizu koju pruža aplikacija. To vam omogućuje da izbjegnete emocionalne trgovačke pogreške, osiguravajući da ulazite u trgovine na temelju tržišne analize temeljene na podacima. Jedna od najboljih stvari o [website_title] jest to što je potpuno besplatno registrirati svoj novi račun. Prijavite se sada i započnite trgovanje na tržištima.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Otvorite besplatan račun sada')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Glavne značajke [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] je najnovija verzija naše moćne trgovačke aplikacije, dizajnirane za pomoć investitorima u pristupu i iskorištavanju visokokvalitetnih trgovačkih prilika na tržištima kriptovaluta. Naše napredne financijske tehnologije kombiniraju više od 15 alata za tehničku analizu kako bi pomogli trgovcima identificirati idealne ulazne i izlazne točke cijena pri trgovanju njihovim omiljenim digitalnim valutama online. Novi [website_title] podržava širi raspon kriptovaluta, nudeći više opcija kada je riječ o trgovanju. Bilo da ste zainteresirani za Bitcoin, Ethereum ili druge popularne kriptovalute, možete ih trgovati na novom [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Napredni trgovački algoritmi" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Napredni trgovački algoritmi')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('Naši trgovački algoritmi su napredniji nego ikada, omogućujući vam da iskoristite tržišne pokrete u stvarnom vremenu. S sofisticiranim algoritmima strojnog učenja, [website_title] može analizirati tržišne podatke i predvidjeti buduće kretanje cijena, dajući vam prednost u vašim trgovinama.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Poboljšano korisničko sučelje" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Poboljšano korisničko sučelje')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "Potpuno smo redizajnirali naše korisničko sučelje, čineći ga intuitivnijim i lakšim za korištenje. Bez obzira jeste li početnik ili iskusni trgovac, novi [website_title] bit će vam jednostavan za navigaciju i upotrebu.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Poboljšana sigurnost" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Poboljšana sigurnost')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "Sigurnost nam je glavni prioritet na [website_title], a nova platforma uključuje niz naprednih sigurnosnih značajki kako bi vaša sredstva i osobni podaci ostali sigurni. Naša platforma je zaštićena SSL enkripcijom i dvofaktorskom autentifikacijom, a koristimo najnovije sigurnosne protokole za zaštitu vaših podataka.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISTRIRAJTE SE SADA")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Kako se prijaviti na [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Korak jedan')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Registracija')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Prvi korak je ispunjavanje obrasca za registraciju koji možete pronaći na našoj web stranici. Od vas će se tražiti da unesete osnovne podatke kao što su vaše ime, prezime, adresa e-pošte i telefonski broj. Nakon što primite e-poruku s potvrdom i kliknete na poveznicu za potvrdu, bit ćete registrirani i vaš novi račun će biti aktiviran. To znači da ćete imati potpuni pristup aplikaciji za trgovanje [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Korak dva')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Financiranje')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Nakon što aktivirate svoj novi račun, morat ćete položiti sredstva na svoj račun. Trgovanje zahtijeva kapital za održavanje vaših pozicija na tržištu. Od vas će se tražiti da uložite minimalni iznos novca za trgovanje pomoću aplikacije [website_title]. Što više uložite, veći je potencijalni profit koji možete ostvariti. Međutim, to također znači povećani rizik od gubitka. Početnicima se savjetuje da u početku budu oprezni i ulažu samo minimalni potreban depozit. To će vam omogućiti da naučite osnove tržišta trgovanja prije nego što uložite veće iznose.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Korak tri')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Trgovanje')}}</h3>
                    </div>
                    <div>{{aiTrans('Na kraju, morat ćete prilagoditi parametre trgovanja u softveru. Aplikacija se može prilagoditi kako bi odgovarala vašoj vlastitoj toleranciji na rizik, preferencijama i ciljevima trgovanja. To će osigurati da imate najbolje moguće iskustvo trgovanja. Nakon što završite s podešavanjem parametara trgovanja, bit ćete spremni za početak trgovanja pomoću našeg moćnog algoritma i analize tržišta.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Prijavite se sada i započnite')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Često postavljana pitanja')}}</h2>
        <p class="faq-text">{{aiTrans('Vrlo je vjerojatno da još uvijek imate neka pitanja o tome kako naša aplikacija za trgovanje funkcionira. Ako ste početnik u trgovanju, vjerojatno imate i pitanja o tome kako započeti. U nastavku su neka od najčešćih pitanja koja dobivamo od trgovaca.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Koja je nova verzija [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nova verzija [website_title] je ažurirana verzija popularne platforme za trgovanje kriptovalutama, dizajnirana kako bi trgovcima pružila još moćnije alate i značajke za pomoć u uspješnom trgovanju na tržištu kriptovaluta.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Koje su nove značajke koje nudi nova verzija [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nova verzija [website_title] nudi niz novih značajki, uključujući napredne alate za upravljanje rizikom, podatke o tržištu u stvarnom vremenu, prilagodljive tablice i grafikone te analizu vijesti i događaja.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Je li nova verzija [website_title] sigurna za korištenje?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Da, nova verzija [website_title] je sigurna za korištenje. Platforma koristi napredne sigurnosne mjere za zaštitu korisničkih podataka i transakcija, a naš tim stručnjaka prati platformu 24/7 kako bi osigurao njezinu sigurnost i pouzdanost.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Mogu li prilagoditi svoje iskustvo trgovanja s novom verzijom [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Da, nova verzija [website_title] omogućuje vam prilagodbu vašeg iskustva trgovanja, uključujući prilagodljive tablice i grafikone koji vam omogućuju jednostavno vizualiziranje tržišnih podataka i trendova.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Je li nova verzija [website_title] prikladna za početnike?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Da, nova verzija [website_title] je prikladna za početnike. Platforma je prilagođena korisnicima i jednostavna za navigaciju, a naš tim stručnjaka dostupan je za pružanje smjernica i podrške trgovcima na svim razinama iskustva.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("REGISTRIRAJTE SE SADA")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Ključne značajke",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">{{aiTrans('Vrsta')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI trgovački robot')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">{{aiTrans('Cijena aplikacije')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Besplatno')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">Naknade</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Ne')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">{{aiTrans('Demo račun')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Da')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">{{aiTrans('Imovina')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH i drugi')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Ključne značajke" class="high-img">
                    <div class="high-text">{{aiTrans('Zaštita korisničkih podataka')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Da')}}</div>

                </div>
            </div>
        </div>
    </div>
</div>
@endsection
