@extends('layouts.app')
@section('title', $website_title .' | OM OS')
@php( $meta_description = "Find ud af, hvordan ". $website_title." hjælper med at udvikle dine investeringsfærdigheder i kryptovaluta. Vi tilbyder avancerede værktøjer og fuld støtte for at nå dine handelsmål.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}} - Hvad er online handel?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('Om os')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Hvad er online handel?')}}</h2>
        <p>{{aiTrans('Online handel begyndte i 1971, da den første handelssoftware, National Association of Securities Dealers Automated Quotations (NASDAQ), blev lanceret som den første online handelssoftware. I dag er online handel den mest populære metode til at købe og sælge forskellige finansielle aktiver som Forex, kryptovalutaer, aktier, råvarer og endda Contracts for Difference (CFDs).')}}</p>
        <p>
            {{ aiTrans(
                "Ud fra dette blev [website_title] skabt.",
                $locale,
                ['website_title' => $website_title],
            ) }}</p>
        <p>{{aiTrans('Den kraftfulde og intuitive handelssoftware er i stand til at udnytte de små prisforskelle på digitale valutaer mellem forskellige børser. Den køber kryptovalutaer til en lav pris og sælger dem derefter til en højere pris. Det endelige resultat er små mængder af profit, som resulterer i store gevinster for brugeren.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Se videoen')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            
            {{ aiTrans(
                "Kryptovalutaer er meget volatile aktiver, og det er vigtigt at træffe gode beslutninger, når man handler med dem. Det er, hvad [website_title] handler om. Den kraftfulde app sikrer, at kryptoinvestorer kan få hurtige og relevante oplysninger, når de handler med deres foretrukne valutaer og tokens på markedet. På den måde kan de følge de bedste muligheder på kryptomarkedet og træffe præcise og informerede handelsbeslutninger hele tiden. [website_title] sikrer grundlæggende, at ingen kryptoinvestor handler blindt. Appen gør det muligt at handle med tillid og få mest muligt ud af din handelsaktivitet.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}} - Team " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Teamet bag [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "[website_title] teamet består af dedikerede handelsprofessionelle, der ønsker at give almindelige mennesker som dig muligheden for effektivt og profitabelt at handle Bitcoins og andre kryptovalutaer. Teamet har kombineret deres viden og erfaring for at skabe en handelssoftwareløsning, der nemt og hurtigt kan scanne de forskellige kryptovalutabørser og identificere profitable handelsmuligheder. Hele processen er automatiseret, hvilket giver alle mulighed for at handle og få deres del af den lukrative handel.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "[website_title] tilbyder mange fordele og fordele, og vi har altid været engageret i at bidrage positivt til din handelsoplevelse og finansielle rejse.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Tilmeld dig nu')}}</a>
        </div>
    </div>
</div>
<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}} - Udnyt kryptomarkederne og tjen med " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Udnyt kryptomarkederne og tjen med [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <p>
            {{ aiTrans(
                "Hos [website_title] vil vi hjælpe dig med at opnå økonomisk frihed, og efterhånden som kryptomarkedet vokser og udvikler sig, er der ingen tvivl om, at der vil opstå flere handelsmuligheder. Dette betyder ganske enkelt mere profit til dig.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <p>
            {{ aiTrans(
                "Tag kontrol over din fremtid i dag og tilmeld dig [website_title]. Din succes vil ændre dit liv. Tilmeld dig nu for din gratis konto og kom i gang med handelen i dag!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
    </div>
</div>
@endsection
