<?php
namespace App\Services;

use Intervention\Image\ImageManagerStatic as Image;
use Spatie\Browsershot\Browsershot;

class ScreenshotService
{
    public static function compareImagesWithIntervention($imagePath1, $imagePath2, $tolerance = 10)
    {
        $img1 = Image::make($imagePath1);
        $img2 = Image::make($imagePath2);

        // Ensure the images have the same dimensions
        if ($img1->width() !== $img2->width() || $img1->height() !== $img2->height()) {
            return false; // Images are not the same size, so cannot be compared directly
        }

        $width = $img1->width();
        $height = $img1->height();
        $totalPixels = $width * $height;
        $differenceCount = 0;

        // Compare each pixel
        for ($x = 0; $x < $width; $x++) {
            for ($y = 0; $y < $height; $y++) {
                $pixel1 = $img1->pickColor($x, $y, 'array');
                $pixel2 = $img2->pickColor($x, $y, 'array');

                // Calculate the difference in each color channel (R, G, B)
                $diff = abs($pixel1[0] - $pixel2[0]) +
                    abs($pixel1[1] - $pixel2[1]) +
                    abs($pixel1[2] - $pixel2[2]);

                // Count as a difference if it exceeds the tolerance
                if ($diff > $tolerance) {
                    $differenceCount++;
                }
            }
        }

        // Calculate the percentage difference
        $differencePercentage = ($differenceCount / $totalPixels) * 100;

        return $differencePercentage; // Return the percentage difference
    }


    public static function takeScreenshot($url, $path)
    {

        Browsershot::url($url)
            ->userAgent('Mozilla/5.0 (iPhone; CPU iPhone OS 11_0 like Mac OS X) AppleWebKit/604.1.38 (KHTML, like Gecko) Version/11.0 Mobile/15A372 Safari/604.1')
            ->windowSize(375, 2000)
            ->mobile()
            ->dismissDialogs()
            ->touch()
            ->waitUntilNetworkIdle(false)
            ->landscape(false)
            ->save($path);

    }
}