<?php

namespace App\Http\Resources\API\Offer;

use App\Support\Traits\WithPagination;
use Illuminate\Http\Resources\Json\JsonResource;

class OfferServiceResource extends JsonResource
{
    use WithPagination;

    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array
     */
    public function toArray($request)
    {

        return [
            'id' => $this->service?->id,
            'title' => $this->service?->title,
            'price' => $this->service?->price,
            'image' => !empty($this->service?->getFirstMediaUrl('image')) ? $this->service?->getFirstMediaUrl('image') : asset('brands/car-service.png'),
        ];
    }
}
