<?php

namespace App\Domain\Core\Datatables;

use App\Domain\Core\Models\Area;
use App\Support\Dashboard\Datatables\BaseDatatable;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class AreaDatatable extends BaseDatatable
{
    public function query(): Builder
    {
        return Area::query();
    }

    protected function filters(): array
    {
        return [
            'title.ar' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            }, 'title.en' => function ($q, $keyword) {
                return $q->where('title', 'like', '%' . $keyword . '%');
            }
        ];
    }

    protected function columns(): array
    {
        return [
            Column::make('title.ar')->title(__('Title') . ' ' . __('Ar'))
                ->content(''),
            Column::make('title.en')->title(__('Title') . ' ' . __('En'))
                ->content(''),
        ];
    }
}
