<?php $__env->startSection('title', $website_title .' | Integritetspolicy'); ?>
<?php ( $meta_description = "Upptäck hur ". $website_title." skyddar din personliga information. Vår integritetspolicy beskriver de åtgärder vi vidtar för att säkerställa säkerheten och transparensen för din information."); ?>

<?php $__env->startSection('content'); ?>
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>INTEGRITETSPOLICY</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3><?php echo e(aiTrans('1. Introduktion', $locale)); ?></h3>
            <p>
                <?php echo e(aiTrans('Detta uttalande beskriver integritetspolicyn som antagits av', $locale)); ?> <?php echo e($website_title); ?> ("<?php echo e(aiTrans('vi', $locale)); ?>," "<?php echo e(aiTrans('vår', $locale)); ?>," "<?php echo e(aiTrans('eller', $locale)); ?>")
                <?php echo e(aiTrans('gällande våra produkter och tjänster ("Tjänster") och', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('webbplats', $locale)); ?></a>
                <?php echo e(aiTrans('("Webbplats")', $locale)); ?>. <?php echo e(aiTrans('Att skydda din integritet och konfidentialiteten av din information är avgörande för oss när vi tillhandahåller våra Tjänster och driver Webbplatsen.', $locale)); ?>

            </p>
            <p>
                <?php echo e(aiTrans('Våra Tjänster och Webbplats kan innehålla länkar till webbplatser och tjänster från tredje part. Vi ansvarar inte för integritetspraxis för dessa externa parter. Vi rekommenderar att du granskar deras integritetspolicy innan du använder dem.', $locale)); ?>

            </p>
            <p>
                <?php echo e(aiTrans('All information som vi erhåller i samband med våra Tjänster behandlas som konfidentiell. Vi använder robusta tekniska, säkerhets- och organisatoriska åtgärder för att skydda Personuppgifter (som definieras nedan) mot obehörig behandling, oavsiktlig förlust, förstörelse, skada, stöld eller utlämning.', $locale)); ?>

            </p>
            <p>
                <?php echo e(aiTrans('När du skickar din information genom vår webbplats kan du bli ombedd att ange personlig information, såsom ditt namn, e-postadress, telefonnummer, födelsedatum och olika identifieringsuppgifter. Denna information kan användas för olika ändamål, bland annat för att verifiera identitet, administrera information, erbjuda teknisk support och uppfylla kontrakts- och lagstadgade skyldigheter. Vi kan kommunicera viktiga detaljer genom meddelanden, och med ditt samtycke kan vi tillhandahålla information om produkter och tjänster via SMS, e-post etc. Du har möjlighet att hantera meddelandeinställningar och avregistrera dig från vissa kommunikationer.', $locale)); ?>

            </p>
            <h3><?php echo e(aiTrans('2. Webbplats; Besökare och Användare', $locale)); ?></h3>
            <h4><?php echo e(aiTrans('2.1. Allmänt', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Denna sektion beskriver specifikationerna för insamling av data från olika grupper: webbplatsbesökare ("Besökare"), användare ("Användare") och affärspartners (tillsammans "Partners"). Personuppgifter inkluderar IP-adress, namn, kontaktinformation och information om relationen med oss, enligt de tillämpliga dataskyddsregleringarna.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.2. Insamling och Användning', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Genom att besöka Webbplatsen samtycker du till insamling och användning av dina Personuppgifter. Om du inte godkänner dessa villkor bör du inte besöka Webbplatsen. Vi kan samla in information genom aktivitet som sidvisningar, IP-adresser och cookies. Dessutom bearbetar vi uppgifter som frivilligt tillhandahålls via formulär och registreringar.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('2.3. Syfte med Behandling av Personuppgifter', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi behandlar Personuppgifter för att förbättra, förstå och anpassa vår Webbplats och Tjänster. Detta inkluderar att förbättra noggrannhet, kommunikation om Tjänster, support, kontraktsförpliktelser och samarbete med partners. Samtycke eller rättslig grund är nödvändigt för all behandling.', $locale)); ?>

</p>
<p><?php echo e(aiTrans('Följande beskriver syften och den rättsliga grunden för behandlingen av Personuppgifter:', $locale)); ?></p>
<table>
    <tbody>
        <tr>
            <td><?php echo e(aiTrans('Registrering som kontoinnehavare', $locale)); ?></td>
            <td><?php echo e(aiTrans('Ditt samtycke; Utförande av Tjänster eller kontraktsförpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Tillhandahållande och användning av Tjänster', $locale)); ?></td>
            <td><?php echo e(aiTrans('Utförande av Tjänster eller kontraktsförpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Operativa uppdateringar', $locale)); ?></td>
            <td><?php echo e(aiTrans('Utförande av Tjänster eller kontraktsförpliktelser', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Svara på förfrågningar och ge support', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen eller utförande av Tjänster', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Tjänster, annonsering och skräddarsydd marknadsföring', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen eller ditt samtycke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Förbättring och erbjudande av nya Tjänster', $locale)); ?></td>
            <td><?php echo e(aiTrans('Samtycke och legitima intressen', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Skicka reklammaterial och marknadsföring', $locale)); ?></td>
            <td><?php echo e(aiTrans('Ditt samtycke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analys av effektiviteten av marknadsföringskampanjer', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen eller samtycke', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Utförande av olika supportaktiviteter', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen eller utförande av Tjänster', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Analys, inklusive statistisk analys', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen', $locale)); ?></td>
        </tr>
        <tr>
            <td><?php echo e(aiTrans('Skydd av intressen, rättigheter och tillgångar', $locale)); ?></td>
            <td><?php echo e(aiTrans('Legitima intressen eller rättsliga förpliktelser', $locale)); ?></td>
        </tr>
    </tbody>
</table>
<h4><?php echo e(aiTrans('2.4. Dela Personuppgifter', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi kan dela information med tjänsteleverantörer, partners och entreprenörer. För besökare och användare inom det europeiska dataskyddsområdet, sker databehandling i enlighet med GDPR och tillämpliga dataskyddslagar.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('3. Partners', $locale)); ?></h3>
<h4><?php echo e(aiTrans('3.1. Allmänt', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('För att tillhandahålla Tjänster och samarbeta med Partners, samlar vi in och bearbetar specifika typer av data. Partners ansvarar för sina egna data, och vi kan få tillgång till dem via säkra metoder.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.2. Behandling av Personuppgifter', $locale)); ?></h4>
<p>
    <?php echo e(aiTrans('Vi förlitar oss på samtycke från Partners eller legitima intressen för att bearbeta Personuppgifter. Aggerade data kan skapas för utveckling och förbättring av kvaliteten.', $locale)); ?>

</p>
<h4><?php echo e(aiTrans('3.3. Personuppgiftsansvarig/Behandlare', $locale)); ?></h4>
<p><?php echo e(aiTrans('Vi kan agera som Personuppgiftsansvarig eller Behandlare beroende på typen av data:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Besökares/Användares data: Personuppgiftsansvarig', $locale)); ?></li>
    <li><?php echo e(aiTrans('Partners data: Behandlare', $locale)); ?></li>
    <li><?php echo e(aiTrans('Alla data är säkert lagrade enligt de högsta säkerhetsstandarderna. Vi implementerar fysiska, tekniska och organisatoriska skyddsåtgärder.', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('3.4. Skydd av Tredjepartsdata', $locale)); ?></h4>
<p><?php echo e(aiTrans('Om Tjänsterna involverar bearbetning av Personuppgifter på en tredjepartsplattform:', $locale)); ?></p>
<ul>
    <li><?php echo e(aiTrans('Vi agerar som Behandlare', $locale)); ?></li>
    <li><?php echo e(aiTrans('Följa tredjeparts instruktioner', $locale)); ?></li>
    <li><?php echo e(aiTrans('Implementera säkerhetsåtgärder', $locale)); ?></li>
    <li><?php echo e(aiTrans('Informera om dataintrång', $locale)); ?></li>
    <li><?php echo e(aiTrans('Inget underleverantörsansvar utan samtycke', $locale)); ?></li>
    <li><?php echo e(aiTrans('Inget bearbetande av data utanför det europeiska ekonomiska området utan samtycke', $locale)); ?></li>
    <li><?php echo e(aiTrans('För elektronisk marknadsföring garanterar vi samtycke och möjlighet att avregistrera sig.', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('4. Säkerhet', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Vi använder administrativa, organisatoriska och tekniska skyddsåtgärder för att skydda Personuppgifter mot obehörig åtkomst, avslöjande, ändring, förlust, missbruk eller otillåten skada. När vi delar data med tredje part säkerställer vi att de upprätthåller samma skyddsnivå för data, och kontraktsåtaganden etableras för exklusiv och säker behandling, i linje med denna Policy.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Om det finns misstankar om att interaktionen med oss har blivit komprometterad, bör Besökare, Användare eller Partners snabbt meddela oss. Det är viktigt att notera att trots våra säkerhetsåtgärder, kan vi inte garantera fullständig immunitet mot tredjepartsangrepp. Användare erkänner de inneboende riskerna och eventuella överträdelser.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('5. Cookies', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Se vår', $locale)); ?> <a href="<?php echo e(route('home',$country)); ?>"><?php echo e(aiTrans('Cookiepolicy', $locale)); ?></a> <?php echo e(aiTrans('för detaljerad information om typerna av cookies och spårningstekniker som används på Webbplatsen, varför de används och hur du accepterar eller avvisar dem.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('6. Länkar till Andra Webbplatser', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Under din användning av Webbplatsen kan Användare stöta på länkar till externa webbplatser som ligger utanför vår kontroll. Vi ansvarar inte för innehåll eller sekretesspolicyer för dessa webbplatser. Användare rekommenderas att granska sekretesspolicyerna för sådana webbplatser och tredjepartstjänster innan de avslöjar någon Personlig Information.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('7. Lagring och Radering', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Personuppgifter, inklusive Personuppgifter, kommer inte att lagras längre än nödvändigt. Besökare och/eller Användare med aktiva konton ansvarar för att radera uppgifterna vid rätt tidpunkt. Efter att ett konto eller partnerskap har avslutats, kommer de Personuppgifter som samlats in via Webbplatsen och/eller Tjänsterna att raderas i enlighet med tillämpliga lagar och våra interna policyer.', $locale)); ?>

</p>
<p>
    <?php echo e(aiTrans('Återkallandet av samtycke för behandling av Personuppgifter kan begränsa tillgången till vissa eller alla begärda Tjänster, utan att några klagomål eller krav kan göras.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('8. Dina Rättigheter', $locale)); ?></h3>
<p><?php echo e(aiTrans('Användare har specifika rättigheter gällande sina Personuppgifter:', $locale)); ?></p>
<h4><?php echo e(aiTrans('8.1. Rätt till Tillgång', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Bekräfta om Personuppgifter behandlas', $locale)); ?></li>
    <li><?php echo e(aiTrans('Få tillgång till Personuppgifter och relaterad information', $locale)); ?></li>
    <li><?php echo e(aiTrans('Information om syften för behandling, kategorier, mottagare, lagringstid, rättigheter och existens av profiler', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.2. Rätt till Rättning', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Rätta felaktiga Personuppgifter', $locale)); ?></li>
    <li><?php echo e(aiTrans('Komplettera ofullständiga Personuppgifter', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.3. Rätt till Radering', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Begära radering av Personuppgifter under specifika omständigheter', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.4. Rätt till Begränsning av Behandling', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Få begränsning av behandlingen under specifika omständigheter', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.5. Rätt till Dataportabilitet', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Ta emot Personuppgifter i ett strukturerat, maskinläsbart format', $locale)); ?></li>
    <li><?php echo e(aiTrans('Överföra Personuppgifter till en annan personuppgiftsansvarig', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.6. Rätt till Invändning', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Invända mot behandling baserat på legitima intressen eller direktmarknadsföring', $locale)); ?></li>
    <li><?php echo e(aiTrans('Stoppa behandlingen, om det inte finns övertygande och/eller tillämpliga rättsliga skäl', $locale)); ?></li>
</ul>
<h4><?php echo e(aiTrans('8.7. Rätt att Återkalla Samtycke', $locale)); ?></h4>
<ul>
    <li><?php echo e(aiTrans('Återkalla samtycke för behandling av Personuppgifter när som helst', $locale)); ?></li>
</ul>
<h3><?php echo e(aiTrans('9. Reklammaterial och Marknadsföring', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Samtycke erhålls för användning av Personuppgifter och kontaktinformation för att tillhandahålla reklammaterial och marknadsföring. Återkallande av samtycke är möjligt genom att skicka ett skriftligt meddelande till den angivna e-postadressen.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('10. Accepterande av denna Policy', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Genom att använda Webbplatsen och/eller Tjänsterna antas Besökare, Användare och/eller Partners ha läst och godkänt denna Policy. Eventuella avvikelser innebär avhållsamhet från att använda plattformen. Vi förbehåller oss rätten att ändra Policyn, och Användare uppmanas att kontrollera uppdateringar regelbundet. Fortsatt användning efter ändringar innebär godkännande.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('11. Laglig Skyldighet att Utlämna Personuppgifter', $locale)); ?></h3>
<p>
    <?php echo e(aiTrans('Personuppgifter kan avslöjas utan föregående samtycke om det finns en tro på att det är nödvändigt för att fastställa identitet, kontakta eller inleda rättsliga förfaranden mot individer som misstänks för att ha kränkt rättigheter eller egendom. Utlämnandet sker när det krävs enligt lag.', $locale)); ?>

</p>
<h3><?php echo e(aiTrans('12. Dataskyddsombud', $locale)); ?></h3>
            <p>
                För frågor om integritet och dataskydd kan ett "Dataskyddsombud" kontaktas via e-post på <span >info<?php echo e('@'.$website_title); ?></span>
            </p>
            <script>
                const emails = document.getElementsByClassName('email');
                for (const email of emails) {
                    email.innerText = `info@${location.hostname}`;
                }
            </script>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/clcl22oneall22/public_html/allclcl22.com/resources/views/frontend/sv/privacy.blade.php ENDPATH**/ ?>