@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Bylting í viðskiptum með kryptómynt: kynning á nýjustu uppfærslunni hjá  [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Bylting í viðskiptum með dulritunargjaldmiðil: kynnir nýjustu uppfærsluna á {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.is.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Takk! Við höfum móttekið innsendinguna þína!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Ó, eitthvað fór úrskeiðis við að senda formið.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Hvað er ?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Hvað er [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "Við erum ánægð með að tilkynna útgáfu nýjustu útgáfu af [website_title] – háþróaðri vettvangi fyrir cryptocurrency viðskipti. Með háþróaðri tækni, nýjustu tækni og notendavænu viðmóti er nýja [website_title] hönnuð til að lyfta viðskiptaupplifun þinni á næsta stig. Þetta áhrifaþungt og innsæi viðskiptatól getur nýtt sér smáar verðmuni á milli mismunandi viðskiptavettvanga. Þar með getur það keypt mynt á lágu verði og selt þær á hærra verði. Lokaniðurstaðan er lítil hagnaður sem skilar stórum hagnaði fyrir notandann.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Skráðu þig núna")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Hvernig byrja ég að versla á netinu?')}}</h2>
        <div class="trading-text">{{aiTrans('Nettímarviðskipti, kaup og sölu á fjármálaeignum á internetinu, eru aðgengileg öllum, óháð fyrri reynslu á alþjóðamörkuðum. Þó það sé auðvelt að byrja, getur verið erfitt að vera arðbær með netviðskiptum. Til að byrja með þarf þú tölvu og áreiðanlega internet tengingu. Þegar þú hefur skráð þig fyrir viðskiptareikning á viðurkenndri vettvangi, getur þú byrjað að versla þegar reikningurinn er virkur og fjármagnaður. Það er áhugavert að þótt það sé auðvelt að byrja, þá er það miklu erfiðara að ná árangri sem viðskiptafólk. Það eru fjölmargir áhættur sem þú þarft að vera meðvitaður um. Mikilvægur þáttur viðskiptanna er skipulögð áætlun, nákvæm markaðsgreining, skilningur á þáttum sem hafa áhrif á verðmæti eigna og tilraunir og mistök. Sumir markaðir geta verið mjög sveiflukenndir, sem getur aukið áhættuna ef þú hefur ekki hæfileika til að nýta tækifæri sem geta komið frá sveiflum. Þrátt fyrir áskoranirnar hefur þróun í reikniritartækni gert þetta auðveldara en nokkru sinni fyrr að byrja að versla með meiri nákvæmni. Reikniritið í appinu mun skoða markaði til að finna viðskipta tækifæri, og með þessum upplýsingum getur þú tekið betri viðskiptarákvarðanir út frá markaðsgreiningu. Með þessum hætti getur jafnvel byrjendur byrjað að versla í sínum uppáhalds eignum á netinu.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Skráðu þig núna")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - Er svindl?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] er svindl?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <p class="not-scam-text">
            {{ aiTrans(
                "Nei, það er ekki. [website_title] lofar ekki tryggðum hagnaði úr cryptocurrency viðskiptum því það er ekki sjálfvirkt viðskiptatól. Appið er aðeins viðskiptaaðstoð. Það var hannað til að hjálpa fjárfestum við að viðskipta með cryptocurrency með öryggi. Appið veitir upplýsingar í rauntíma fyrir kaupmenn og hjálpar þeim að taka fljótar og nákvæmar ákvarðanir þegar þeir viðskiptast með uppáhalds cryptocurrencies sínar á netinu. Auk þess er appið öruggt og tekur ekki á sig nein persónuleg eða fjárhagsupplýsingar viðskiptavina.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </p>
        <div class="button-wrapper">
            <a href="#formTop" class="button white w-button">{{aiTrans("SKRÁÐU ÞIG NÚNA")}}</a>
        </div>
    </div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Hvernig bætir appið viðskipti þín?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Hvernig bætir appið [website_title] viðskipti þín?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Ekkert mál hversu mikla færni þú hefur í netviðskiptum, þú getur haft gagn af öflugu viðskiptaeigindunum sem appið [website_title] býður. Fyrst þarftu þó að skilja hvernig hugbúnaðurinn virkar. [website_title] getur greint markaði með því að nota háþróaða reikniriti sem notar miklar markaðsgögn og mikilvæg tæknileg vísbendingar til að finna viðskipta sem líklegast eru. Þú getur einnig stillt breytur í einföldu og notendavænu viðmóti hugbúnaðarins. Eftir því sem þú fer út frá hæfni, áhættutolerans og áhugamálum getur þú stillt hvernig hugbúnaðurinn virkar. Þetta gerir þér kleift að byrja jafnvel ef þú ert byrjandi. Auk þess eru aðrir mikilvægir eiginleikar eins og þegar þú byrjar að ná árangri sem viðskiptafólk, þá getur hugbúnaðurinn enn nýst til að staðfesta eigin markaðsgreiningu áður en þú fer út í viðskipti. Þegar þú verður meira reynslumikill getur hugbúnaðurinn einnig hjálpað til við að forðast viðskipti sem eru byggð á tilfinningum, og tryggja að þú takir ákvarðanir sem byggja á markaðsgreiningu.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Opnaðu ókeypis reikning núna')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "Helstu eiginleikar [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] 3.0 er nýjasta útgáfan af öflugu viðskiptaforritinu okkar, sem er hannað til að hjálpa fjárfestum að nýta markaðstækifæri með cryptocurrency viðskiptum. Nýjungar í tækni okkar sameina yfir 15 verkfæri sem veita kaup og sölumöguleika fyrir notendur sem nýta sér tæknilega greiningu.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Háþróuð viðskipta reiknirit" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Háþróuð viðskipta reiknirit')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('Viðskipta reiknirit okkar eru nú meiri en nokkru sinni fyrr og veita möguleika á að nýta markaðsviðbrögð í rauntíma. Með háþróuðu reikniritum sem byggjast á sjálfvirkri greiningu, getur [website_title] greint markaðinn með því að spá fyrir um verðþróun.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Bætt viðmót" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Bætt viðmót')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        
                        {{ aiTrans(
                            "Við höfum endurhannað viðmótið okkar og gert það auðveldara að nýta. Hvort sem þú ert byrjandi eða viðskiptafólk með reynslu, þá verður þú að finna [website_title] auðvelt í notkun.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Bætt öryggi" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Bætt öryggi')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "Öryggi er okkar fyrst og fremst við [website_title] og nýja paltan okkar inniheldur margt sem styrkir öryggi. Við höfum SSL dulkóðun og tvíþætt auðkenningu fyrir allar upplýsingar viðskiptavina.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("SKRÁÐU ÞIG NÚNA")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Hvernig skráir þú þig á [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Skref eitt')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Skráning')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Fyrsta skrefið er að fylla út skráningarformið á vefnum okkar. Þú verður beðinn um að gefa upp upplýsingar eins og nafn, netfang og símanúmer. Þegar þú hefur fengið staðfestingarpóstinn og smellt á staðfestingartengilinn, verður þú skráður og færð aðgang að nýja [website_title] viðskiptavettvanginum.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Skref tvö')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Fjármögnun')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "Eftir að þú hefur virkjað nýja reikninginn, þarftu að bæta fé á reikninginn þinn. Viðskipti krefjast fjármagna til að halda viðskiptum þínum opnum. Þú verður að leggja fram lágmarks fjárhæð til að nýta [website_title] viðskipti. Meira fjárfesting getur skilað meiri hagnaði, en hefur einnig áhættu.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('Skref þrjú')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('Viðskipti')}}</h3>
                    </div>
                    <div>{{aiTrans('Að lokum þarftu að stilla viðskiptabreytur í hugbúnaðinum. Þetta mun tryggja að þú fáir bestu viðskiptaupplifunina þegar þú byrjað að nýta markaðssýn í viðskiptum.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Skráðu þig núna til að byrja')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('Algengar spurningar')}}</h2>
        <p class="faq-text">{{aiTrans('Það er líklegt að þú hafir enn einhverjar áhyggjur eða spurningar um hvernig appið okkar virkar. Ef þú ert byrjandi, ættir þú líklega að hafa spurningar um hvernig byrja á þessu. Hér eru nokkrar algengar spurningar sem við fáum oft frá viðskiptavinum.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Hvað er nýja útgáfan af [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nýja útgáfan af [website_title] er uppfærð útgáfa af vinsælum cryptocurrency viðskiptaforritum sem veitir kaupmönnum nýja eiginleika og betri tæknilega greiningu.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Hverjir eru nýju eiginleikar í nýju útgáfu af [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Nýja útgáfan af [website_title] býður upp á nýja eiginleika eins og háþróaða áhættustýringu og rauntíma markaðsgögn.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Er nýja útgáfan af [website_title] örugg?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Já, nýja útgáfan af [website_title] er örugg. Við notum háþróaða öryggisráðstafanir og fylgjumst með öllum viðskiptum okkar allan sólarhringinn.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Get ég persónulega sérsniðið viðskiptaupplifun mína með nýju útgáfunni af [website_title]?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Já, nýja útgáfan af [website_title] leyfir þér að sérsníða viðskiptaupplifunina með viðskiptahjálp sem er auðvelt að stilla.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "Er nýja útgáfan af [website_title] fyrir byrjendur?",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "Já, nýja útgáfan er hönnuð fyrir byrjendur og viðskiptafólk með reynslu. Við bjóðum ráðgjöf og stuðning við viðskiptavini í öllum reynslustigum.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("SKRÁÐU ÞIG NÚNA")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Helstu atriði",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Gerð')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI viðskiptaroboti')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Kostnaður við appið')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Ókeypis')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Highlights" class="high-img">
                    <div class="high-text">Þóknanir</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Enginn')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Þjálfunarreikningur')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Já')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Eignir')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH og aðrir')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Highlights" class="high-img">
                    <div class="high-text">{{aiTrans('Vernd notendagagna')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Já')}}</div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
