@extends('layouts.app')
@section('title', $website_title .' | Pravila privatnosti')
@php( $meta_description = "Otkrijte kako ". $website_title." štiti vaše osobne podatke. Naša pravila privatnosti detaljno opisuju mjere koje poduzimamo kako bismo osigurali sigurnost i transparentnost vaših informacija.")

@section('content')
<div class="privacy-policy wf-section">
    <div class="w-container">
        <h1>PRAVILA PRIVATNOSTI</h1>
        <div>
            <style>
                table {
                    width: 100%;
                }

                table,
                th,
                td {
                    border: 1px solid;
                    border-collapse: collapse;
                }

                th,
                td {
                    padding: 10px;
                }

                table td {
                    vertical-align: top;
                }

                .nested-list {
                    counter-reset: item;
                }

                .nested-list li {
                    display: block;
                }

                .nested-list li:before {
                    content: counters(item, '.') '. ';
                    counter-increment: item;
                }

                .legal-section {
                    text-align: left;
                }

                .legal-section h3 {
                    margin-top: 30px;
                    font-size: 24px;
                }

                .legal-section h4 {
                    font-size: 18px;
                }
            </style>
            <p>
            </p>
            <h3>{{ aiTrans('1. Uvod', $locale) }}</h3>
<p>
    {{ aiTrans('Ova izjava opisuje pravila privatnosti koja provodi', $locale) }} {{ $website_title }} ("{{ aiTrans('mi', $locale) }}," "{{ aiTrans('naš', $locale) }}," "{{ aiTrans('ili', $locale) }}")
    {{ aiTrans('u vezi s našim proizvodima i uslugama ("Usluge") i', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('web stranicom', $locale) }}</a>
    {{ aiTrans('("Stranica")', $locale) }}. {{ aiTrans('Zaštita vaše privatnosti i povjerljivosti vaših podataka ključna je za nas pri pružanju naših Usluga i upravljanju Stranicom.', $locale) }}
</p>
<p>
    {{ aiTrans('Naše Usluge i Stranica mogu sadržavati poveznice na web stranice i usluge trećih strana. Nismo odgovorni za njihove prakse privatnosti. Preporučujemo da pregledate njihova pravila privatnosti prije nego što ih koristite.', $locale) }}
</p>
<p>
    {{ aiTrans('Sve informacije koje prikupimo u vezi s našim Uslugama smatramo povjerljivima. Koristimo snažne tehničke, sigurnosne i organizacijske mjere kako bismo zaštitili Osobne podatke (kako je definirano u nastavku) od neovlaštene obrade, slučajnog gubitka, uništenja, oštećenja, krađe ili otkrivanja.', $locale) }}
</p>
<p>
    {{ aiTrans('Kada šaljete svoje podatke putem naše stranice, možda ćete biti zamoljeni da navedete osobne podatke, poput vašeg imena, e-maila, broja telefona, datuma rođenja i drugih identifikacijskih podataka. Ti se podaci mogu koristiti, između ostalog, za provjeru identiteta, administraciju podataka, tehničku podršku i ispunjavanje ugovornih i zakonskih obveza. Možemo vas obavještavati o važnim informacijama putem notifikacija, a uz vaš pristanak, pružati informacije o proizvodima i uslugama putem SMS-a, e-maila itd. Možete upravljati postavkama obavijesti i odjaviti se iz određenih komunikacija.', $locale) }}
</p>
<h3>{{ aiTrans('2. Stranica; Posjetitelji i Korisnici', $locale) }}</h3>
<h4>{{ aiTrans('2.1. Općenito', $locale) }}</h4>
<p>
    {{ aiTrans('Ovaj odjeljak opisuje specifičnosti prikupljanja podataka od različitih grupa: posjetitelja web stranice ("Posjetitelji"), korisnika ("Korisnici") i poslovnih partnera (zajedno "Partneri"). Osobni podaci uključuju IP adresu, ime, kontaktne podatke i informacije o našem odnosu s vama, u skladu s primjenjivim propisima o zaštiti podataka.', $locale) }}
</p>
<h4>{{ aiTrans('2.2. Prikupljanje i korištenje', $locale) }}</h4>

<p>
    {{ aiTrans('Posjetom Stranici pristajete na prikupljanje i korištenje vaših Osobnih podataka. Ako se ne slažete s ovim uvjetima, ne biste trebali posjećivati Stranicu. Možemo prikupljati informacije putem aktivnosti pregleda stranica, IP adresa i kolačića. Osim toga, obrađujemo podatke koje dobrovoljno dostavite putem obrazaca i registracija.', $locale) }}
</p>
<h4>{{ aiTrans('2.3. Svrha obrade osobnih podataka', $locale) }}</h4>
<p>
    {{ aiTrans('Obrađujemo Osobne podatke kako bismo poboljšali, razumjeli i prilagodili našu Stranicu i Usluge. To uključuje poboljšanje točnosti, komunikaciju o Uslugama, podršku, ugovorne obveze i suradnju s partnerima. Pristanak ili pravna osnova ključni su za svaku obradu.', $locale) }}
</p>
<p>{{ aiTrans('Sljedeće opisuje svrhe i pravne osnove za obradu Osobnih podataka:', $locale) }}</p>
<table>
    <tbody>
        <tr>
            <td>{{ aiTrans('Registracija kao vlasnik računa', $locale) }}</td>
            <td>{{ aiTrans('Vaš pristanak; Izvršenje Usluga ili ugovornih obveza', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Pružanje i korištenje Usluga', $locale) }}</td>
            <td>{{ aiTrans('Izvršenje Usluga ili ugovornih obveza', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Operativna ažuriranja', $locale) }}</td>
            <td>{{ aiTrans('Izvršenje Usluga ili ugovornih obveza', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Odgovaranje na upite i pružanje podrške', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi ili izvršenje Usluga', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Prilagođene usluge, oglašavanje i marketing', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi ili vaš pristanak', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Poboljšanje i ponuda novih Usluga', $locale) }}</td>
            <td>{{ aiTrans('Pristanak i legitimni interesi', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Slanje reklamnih i marketinških materijala', $locale) }}</td>
            <td>{{ aiTrans('Vaš pristanak', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analiza učinkovitosti marketinških kampanja', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi ili pristanak', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Izvršenje različitih aktivnosti podrške', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi ili izvršenje Usluga', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Analiza, uključujući statističku analizu', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi', $locale) }}</td>
        </tr>
        <tr>
            <td>{{ aiTrans('Zaštita interesa, prava i imovine', $locale) }}</td>
            <td>{{ aiTrans('Legitimni interesi ili pravne obveze', $locale) }}</td>
        </tr>
    </tbody>
</table>
<h4>{{ aiTrans('2.4. Dijeljenje osobnih podataka', $locale) }}</h4>
<p>
    {{ aiTrans('Možemo dijeliti informacije s pružateljima usluga, Partnerima i izvođačima. Za Posjetitelje i Korisnike u Europskoj podatkovnoj regiji, obrada podataka usklađena je s GDPR-om i primjenjivim Zakonima o zaštiti podataka.', $locale) }}
</p>
<h3>{{ aiTrans('3. Partneri', $locale) }}</h3>
<h4>{{ aiTrans('3.1. Općenito', $locale) }}</h4>
<p>
    {{ aiTrans('Kako bismo pružali Usluge i surađivali s Partnerima, prikupljamo i obrađujemo određene vrste podataka. Partneri su odgovorni za svoje podatke, a mi im možemo pristupiti sigurnim kanalima.', $locale) }}
</p>
<h4>{{ aiTrans('3.2. Obrada osobnih podataka', $locale) }}</h4>
<p>
    {{ aiTrans('Oslanjamo se na pristanak Partnera ili legitimne interese za obradu Osobnih podataka. Moguće je kreirati agregirane podatke radi razvoja i poboljšanja kvalitete.', $locale) }}
</p>
<h4>{{ aiTrans('3.3. Voditelj obrade/Izvršitelj obrade', $locale) }}</h4>
<p>{{ aiTrans('Možemo djelovati kao Voditelj obrade ili Izvršitelj obrade, ovisno o vrsti podataka:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Podaci Posjetitelja/Korisnika: Voditelj obrade', $locale) }}</li>
    <li>{{ aiTrans('Podaci Partnera: Izvršitelj obrade', $locale) }}</li>
    <li>{{ aiTrans('Svi podaci pohranjeni su sigurno, u skladu s najvišim sigurnosnim standardima. Implementirali smo fizičke, tehničke i organizacijske mjere zaštite.', $locale) }}</li>
</ul>
<h4>{{ aiTrans('3.4. Zaštita podataka trećih strana', $locale) }}</h4>
<p>{{ aiTrans('Ako Usluge uključuju obradu Osobnih podataka na platformi treće strane:', $locale) }}</p>
<ul>
    <li>{{ aiTrans('Djelujemo kao Izvršitelj obrade', $locale) }}</li>
    <li>{{ aiTrans('Postupamo u skladu s uputama treće strane', $locale) }}</li>
    <li>{{ aiTrans('Provodimo sigurnosne mjere', $locale) }}</li>
    <li>{{ aiTrans('Obavještavamo o povredama podataka', $locale) }}</li>
    <li>{{ aiTrans('Ne podugovaramo bez pristanka', $locale) }}</li>
    <li>{{ aiTrans('Ne obrađujemo podatke izvan Europskog gospodarskog prostora bez pristanka', $locale) }}</li>
    <li>{{ aiTrans('Za elektroničke marketinške komunikacije osiguravamo pristanak i mogućnosti otkazivanja.', $locale) }}</li>
</ul>
<h3>{{ aiTrans('4. Sigurnost', $locale) }}</h3>
<p>
    {{ aiTrans('Koristimo administrativne, organizacijske i tehničke mjere zaštite kako bismo Osobne podatke zaštitili od neovlaštenog pristupa, otkrivanja, izmjene, gubitka, zloupotrebe ili oštećenja. Pri dijeljenju podataka s trećim stranama, osiguravamo da poštuju iste standarde zaštite podataka i postavljamo ugovorne obveze za isključivu i sigurnu obradu, u skladu s ovom Politikom.', $locale) }}
</p>
<p>
    {{ aiTrans('Ako vjerujete da je vaša interakcija s nama ugrožena, Posjetitelji, Korisnici ili Partneri trebaju nas odmah obavijestiti. Važno je napomenuti da, unatoč našim sigurnosnim mjerama, ne možemo jamčiti potpunu imunost od napada trećih strana. Korisnici prihvaćaju postojeće rizike i moguće povrede.', $locale) }}
</p>
<h3>{{ aiTrans('5. Kolačići', $locale) }}</h3>
<p>
    {{ aiTrans('Pogledajte našu', $locale) }} <a href="{{route('home',$country)}}">{{ aiTrans('Politiku kolačića', $locale) }}</a> {{ aiTrans('za detaljne informacije o vrstama kolačića i tehnologijama praćenja koje koristimo na Stranici, razlozima njihove upotrebe i kako ih prihvatiti ili odbiti.', $locale) }}
</p>
<h3>{{ aiTrans('6. Poveznice na druge web stranice', $locale) }}</h3>
<p>
    {{ aiTrans('Tijekom pregledavanja Stranice, Korisnici mogu naići na poveznice na vanjske web stranice koje su izvan naše kontrole. Ne odgovaramo za sadržaj ili pravila privatnosti tih web stranica. Korisnicima savjetujemo da pregledaju pravila privatnosti takvih web stranica i usluga trećih strana prije nego što otkriju bilo kakve Osobne podatke.', $locale) }}
</p>
<h3>{{ aiTrans('7. Pohrana i brisanje podataka', $locale) }}</h3>
<p>
    {{ aiTrans('Podaci, uključujući Osobne podatke, neće se čuvati dulje nego što je potrebno. Posjetitelji i/ili Korisnici s aktivnim računima odgovorni su za pravovremeno brisanje podataka. Nakon ukidanja računa ili partnerstva, Osobni podaci prikupljeni putem Stranice i/ili Usluga bit će izbrisani u skladu s primjenjivim zakonima i našim internim pravilima.', $locale) }}
</p>
<p>
    {{ aiTrans('Povlačenje pristanka za obradu Osobnih podataka može ograničiti pristup nekim ili svim traženim Uslugama, bez mogućnosti podnošenja pritužbi ili sporova.', $locale) }}
</p>
<h3>{{ aiTrans('8. Vaša prava', $locale) }}</h3>
<p>{{ aiTrans('Korisnici imaju određena prava u vezi s njihovim Osobnim podacima:', $locale) }}</p>
<h4>{{ aiTrans('8.1. Pravo na pristup', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Potvrditi obrađuju li se Osobni podaci', $locale) }}</li>
    <li>{{ aiTrans('Pristupiti Osobnim podacima i povezanim informacijama', $locale) }}</li>
    <li>{{ aiTrans('Informacije o svrsi obrade, kategorijama, primateljima, trajanju pohrane, pravima i postojanju profiliranja', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.2. Pravo na ispravak', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Ispraviti netočne Osobne podatke', $locale) }}</li>
    <li>{{ aiTrans('Dovršiti nepotpune Osobne podatke', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.3. Pravo na brisanje', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Zatražiti brisanje Osobnih podataka u određenim okolnostima', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.4. Pravo na ograničenje obrade', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Dobiti ograničenje obrade u određenim okolnostima', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.5. Pravo na prijenos podataka', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Primiti Osobne podatke u strukturiranom i strojno čitljivom formatu', $locale) }}</li>
    <li>{{ aiTrans('Prenijeti Osobne podatke drugom voditelju obrade', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.6. Pravo na prigovor', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Uložiti prigovor na obradu temeljenu na legitimnim interesima ili izravnom marketingu', $locale) }}</li>
    <li>{{ aiTrans('Zaustaviti obradu osim ako ne postoje uvjerljivi i/ili pravno primjenjivi razlozi', $locale) }}</li>
</ul>
<h4>{{ aiTrans('8.7. Pravo na povlačenje pristanka', $locale) }}</h4>
<ul>
    <li>{{ aiTrans('Povući pristanak za obradu Osobnih podataka u bilo kojem trenutku', $locale) }}</li>
</ul>
<h3>{{ aiTrans('9. Reklamni i marketinški materijali', $locale) }}</h3>
<p>
    {{ aiTrans('Pristanak se dobiva za korištenje Osobnih podataka i kontaktnih podataka za slanje reklamnih i marketinških materijala. Povlačenje pristanka moguće je slanjem pisanog obavještenja na navedenu e-mail adresu.', $locale) }}
</p>
<h3>{{ aiTrans('10. Prihvaćanje ove Politike', $locale) }}</h3>
<p>
    {{ aiTrans('Korištenjem Stranice i/ili Usluga, Posjetitelji, Korisnici i/ili Partneri smatraju se da su pročitali i da se slažu s ovom Politikom. Svako neslaganje podrazumijeva suzdržavanje od korištenja platforme. Zadržavamo pravo izmjene Politike, a Korisnici se potiču da redovito provjeravaju ažuriranja. Daljnje korištenje nakon izmjena znači prihvaćanje.', $locale) }}
</p>
<h3>{{ aiTrans('11. Pravna obveza otkrivanja Osobnih podataka', $locale) }}</h3>
<p>
    {{ aiTrans('Osobni podaci mogu biti otkriveni bez prethodnog odobrenja ako postoji uvjerenje da je to potrebno za utvrđivanje identiteta, kontaktiranje ili pokretanje pravnih postupaka protiv osoba osumnjičenih za kršenje prava ili imovine. Otkrivanje će biti izvršeno kada je to zakonski propisano.', $locale) }}
</p>
<h3>{{ aiTrans('12. Službenik za zaštitu podataka', $locale) }}</h3>
<p>
    Za pitanja o privatnosti i zaštiti podataka, imenovani "Službenik za zaštitu podataka" može se kontaktirati putem e-maila <span >info{{ '@'.$website_title }}</span>
</p>
<script>
    const emails = document.getElementsByClassName('email');
    for (const email of emails) {
        email.innerText = `info@${location.hostname}`;
    }
</script>

        </div>
    </div>
</div>
@endsection
