@extends('layouts.app')
@section('title', $website_title .' | O NAMA')
@php( $meta_description = "Otkrijte kako ". $website_title." pomaže u razvoju vaših vještina ulaganja u kriptovalute. Nudimo napredne alate i potpunu podršku za postizanje vaših trgovačkih ciljeva.")

@section('content')
<div class="what-is w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/what-is-img.webp"  sizes="(max-width: 991px) 100vw, (max-width: 2870px) 50vw, 1435px" alt="{{$website_title}}  - Što točno znači online trgovanje?" class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h1 class="about-title">{{aiTrans('O nama')}}</h1>
        <h2 class="about-subtitle">{{aiTrans('Što točno znači online trgovanje?')}}</h2>
        <p>{{aiTrans('Online trgovanje započelo je 1971. godine kada je prvi softver za trgovanje, National Association of Securities Dealers Automated Quotations (NASDAQ), lansiran kao prvi softver za online trgovanje. Danas je online trgovanje najpopularniji način kupnje i prodaje raznih financijskih instrumenata, uključujući Forex, kriptovalute, dionice, robu i čak ugovore za razliku (CFD-ove).')}}</p>
        <p>
            {{ aiTrans(
                "Na temelju toga nastao je [website_title].",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
        <p>{{aiTrans('Moćan i intuitivan softver za trgovanje može iskoristiti male razlike u cijenama digitalnih valuta između različitih burzi. Zatim će kupiti kriptovalute po niskoj cijeni i prodati ih po višoj. Krajnji rezultat su mali profiti koji se akumuliraju u značajne dobitke za korisnika.')}}</p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Pogledajte video')}}</a>
        </div>
    </div>
    <div class="what-is-bg-1"></div>
</div>

<div class="how-it-working wf-section">
    <div class="container w-container">
        <div class="how-it-working-text">
            {{ aiTrans(
                "Kriptovalute su vrlo volatilna imovina i važno je donositi pametne odluke prilikom trgovanja. To je upravo ono što [website_title] omogućuje. Ova moćna aplikacija osigurava da kripto investitori mogu pristupiti brzim i relevantnim informacijama dok trguju svojim omiljenim kovanicama i tokenima na tržištu. Na taj način mogu pratiti najbolje prilike na tržištima kriptovaluta i donositi precizne i informirane odluke prilikom trgovanja. [website_title] osigurava da nijedan kripto investitor ne trguje naslijepo. Aplikacija vam omogućuje trgovanje s povjerenjem i maksimalno iskorištavanje vaših trgovačkih aktivnosti.",
                $locale,
                ['website_title' => $website_title],
            ) }}</div>
    </div>
</div>

<div class="our-team w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/our-team-img.webp"  sizes="(max-width: 991px) 100vw, 50vw" alt="{{$website_title}}  - Tim {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-team-title">
            {{ aiTrans(
                "Tim [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <p>
            {{ aiTrans(
                "Tim [website_title] sastoji se od predanih stručnjaka za trgovanje koji žele omogućiti običnim ljudima, poput vas, priliku za učinkovito i profitabilno trgovanje Bitcoinom i drugim kriptovalutama. Tim je kombinirao svoje znanje i iskustvo kako bi stvorio softversko rješenje koje može brzo i jednostavno skenirati različite kripto burze i identificirati profitabilne prilike za trgovanje. Cijeli proces je automatiziran, omogućujući svima da trguju i osiguraju svoj dio ovog unosnog tržišta.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
        <p>
            {{ aiTrans(
                "[website_title] nudi mnoge prednosti i pogodnosti te se uvijek obvezujemo pridonijeti pozitivno vašem trgovačkom iskustvu i financijskom putovanju.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
        <div class="button-wrapper margin-top-30">
            <a href="{{route('home',$country)}}#formTop" class="button w-button">{{aiTrans('Registrirajte se sada')}}</a>
        </div>
    </div>
</div>

<div class="our-advantage w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/advantage-img.webp"  alt="{{$website_title}}  - Iskoristite tržište kriptovaluta i ostvarite dobit s {{$website_title}} " class="img-float-right max-width-50-percent">
    <div class="container w-container">
        <h2 class="our-advantage-title">
            {{ aiTrans(
                "Iskoristite tržište kriptovaluta i ostvarite dobit s [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <p>
            {{ aiTrans(
                "U [website_title] želimo vam pomoći da postignete financijsku slobodu, a kako tržište kriptovaluta raste i razvija se, nema sumnje da će se pojaviti više trgovačkih prilika. To jednostavno znači više profita za vas.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
        <p>
            {{ aiTrans(
                "Preuzmite kontrolu nad svojom budućnošću već danas i registrirajte se na [website_title]. Vaš uspjeh može promijeniti vaš život. Registrirajte se sada za svoj besplatni račun i započnite trgovanje još danas!",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </p>
    </div>
</div>
@endsection
