@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "Kryptovaluuttakaupan vallankumous: esittelemme uusimman päivityksen [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col"><img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - Vallankumouksellinen kryptovaluuttakauppa: esittelemme uusimman päivityksen {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.fi.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('Thank you! Your submission has been received!')}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('Oops! Something went wrong while submitting the form.')}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" width="500" alt="{{$website_title}} - Ano ang {{$website_title}}?" class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
                "Mitkä ovat [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
    {{ aiTrans(
        "Olemme iloisia voidessamme ilmoittaa uuden version [website_title] julkaisusta – uusimmasta alustasta kryptovaluuttakauppaan. Kehittyneiden ominaisuuksien, innovatiivisen teknologian ja käyttäjäystävällisen käyttöliittymän ansiosta uusi [website_title] on suunniteltu viemään kaupankäyntikokemuksesi uudelle tasolle. Tehokas ja helppokäyttöinen kaupankäyntiohjelmisto pystyy hyödyntämään pienten hintaerojen mahdollisuuksia eri kryptovaluuttapörsseissä. Se ostaa kryptovaluuttoja alhaisilla hinnoilla ja myy niitä korkeammilla hinnoilla. Lopputuloksena ovat pienet voitot, jotka kertyvät merkittäviksi tuotoiksi käyttäjälle.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>

        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("Rekisteröidy nyt")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('Miten voin aloittaa verkossa kaupankäynnin?')}}</h2>
<div class="trading-text">{{aiTrans('Verkkokaupankäynti, eli rahoitusvarojen ostaminen ja myyminen Internetin välityksellä, on mahdollista lähes kaikille riippumatta heidän aiemmasta kokemuksestaan maailmanlaajuisilla rahoitusmarkkinoilla. Vaikka kaupankäynnin aloittaminen on helppoa, menestyminen voi olla haastavaa. Päästäksesi alkuun tarvitset tietokoneen ja luotettavan Internet-yhteyden. Kun olet rekisteröinyt kaupankäyntitilin hyvämaineisella alustalla, voit aloittaa kaupankäynnin heti, kun tilisi on aktivoitu ja rahoitettu. On tärkeää huomata, että vaikka kaupankäynnin aloittaminen on helppoa, menestyvän kauppiaan ura vaatii enemmän työtä. Kaupankäyntiin liittyy monia riskejä, joista sinun tulisi olla tietoinen. Suuri osa kaupankäynnistä edellyttää huolellista suunnittelua, tarkkaa markkina-analyysiä, varojen hintaan vaikuttavien tekijöiden ymmärtämistä sekä kokeilua ja erehdystä. Jotkut omaisuusmarkkinat voivat olla myös erittäin epävakaita, mikä voi lisätä tappioriskiäsi, jos et osaa hyödyntää volatiliteetin tarjoamia tuottoisia mahdollisuuksia. Haasteista huolimatta algoritmisen kaupankäynnin innovatiivisten teknologioiden ansiosta tämäntyyppinen ohjelmisto on tehnyt verkkokaupankäynnin aloittamisesta helpompaa kuin koskaan aiemmin. Sovelluksen algoritmi analysoi markkinoita kaupankäyntimahdollisuuksien tunnistamiseksi, ja tämän tiedon avulla voit tehdä älykkäämpiä kaupankäyntipäätöksiä markkina-analyysin perusteella. Näin jopa aloittelijat voivat aloittaa suosikkiomaisuuksiensa kaupankäynnin verkossa.')}}</div>
<div class="button-wrapper">
    <a href="#formTop" class="button w-button">{{aiTrans("Rekisteröidy nyt")}}</a>
    <div class="trading-bg2"></div>
</div>

    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="not-scam w-clearfix wf-section">
    <div class="not-scam-bg-1"></div>
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/not-scam-img.webp" alt="{{$website_title}} - {{$website_title}} on huijaus?" class="img-float-right not-scam-img">
    <div class="container w-container">
        <h3 class="not-scam-title">
            {{ aiTrans(
                "[website_title] on huijaus?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
<p class="not-scam-text">
    {{ aiTrans(
        "Ei, ei ole. [website_title] ei lupaa taattuja voittoja kryptovaluuttakaupankäynnissä, koska se ei ole automaattinen kaupankäyntiohjelmisto. Sovellus toimii ainoastaan kaupankäynnin apuvälineenä. Se on suunniteltu auttamaan sijoittajia käymään kryptovaluuttakauppaa itsevarmasti. Sovellus tarjoaa reaaliaikaista dataan perustuvaa tietoa kauppiaille, auttaen heitä tekemään nopeita ja tarkkoja päätöksiä käydessään kauppaa suosikkikryptovaluutoillaan verkossa. Lisäksi sovellus on turvallinen eikä vaaranna asiakkaidensa henkilökohtaisia tai taloudellisia tietoja.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>

        <div class="button-wrapper">
            <a href="#formTop" class="button white w-button">{{aiTrans("REKISTERÖIDY NYT")}}</a>
        </div>
    </div>
</div>


</div>

<div class="improve-your-trading w-clearfix wf-section">
    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" alt="{{$website_title}} - Miten sovellus {{$website_title}} parantaa kaupankäyntiäsi?" class="img-float-right improve-your-trading-img">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "Miten sovellus parantaa kaupankäyntiäsi?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "Ei ole väliä, minkä tasoinen verkkokauppias olet, voit hyödyntää [website_title] -sovelluksen tehokkaita kaupankäyntiominaisuuksia. Ensin on kuitenkin tärkeää ymmärtää, miten ohjelmisto toimii. [website_title] pystyy analysoimaan markkinoita erittäin kehittyneen algoritmin avulla, joka yhdistää valtavia määriä markkinadataa sekä keskeisiä teknisiä indikaattoreita tunnistaakseen suuren todennäköisyyden kaupankäyntimahdollisuudet. Voit myös mukauttaa ohjelmiston asetuksia intuitiivisen käyttöliittymän avulla. Sinun tarvitsee vain säätää ohjelmiston toimintaa oman taitotasosi, riskinsietokykysi ja mieltymystesi mukaan.

Ohjelmisto antaa jopa aloittelijoille mahdollisuuden käydä kauppaa markkinoilla ilman, että heidän tarvitsee huolehtia virheistä hintaliikkeiden analysoinnissa tai oikean kaupankäyntiajan valitsemisessa. Lisäksi, kun kehityt kauppiaana, saatat haluta ottaa käyttöön käytännöllisemmän lähestymistavan. Tällöin ohjelmisto voi edelleen olla erittäin hyödyllinen omien markkina-analyysiesi vahvistamiseen ennen kaupankäyntipäätöksen tekemistä.

Jopa korkeammalla taitotasolla saatat kohdata tilanteita, joissa olet liian hermostunut tai liian innostunut tekemään loogisia kaupankäyntipäätöksiä. Näissä tapauksissa voit hyödyntää sovelluksen tarjoamaa markkina-analyysiä. Tämä auttaa sinua välttämään tunneperäiset kaupankäyntivirheet ja varmistaa, että teet tietoon perustuvia kauppoja markkina-analyysin pohjalta.

Yksi parhaista asioista [website_title] -sovelluksessa on, että uuden tilin rekisteröinti on täysin ilmaista. Rekisteröidy nyt ja aloita kaupankäynti markkinoilla!.",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('Magbukas ng libreng account ngayon at simulan ang pangangalakal')}}</a>
        </div>
    </div>
</div>


        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>


<h2 class="features-title">
    {{ aiTrans(
        "Tärkeimmät ominaisuudet [website_title]",
        $locale,
        ['website_title' => $website_title],
    ) }}
</h2>
<div class="features-text">
    {{ aiTrans(
        "[website_title] on uusin versio tehokkaasta kaupankäyntisovelluksestamme, joka on suunniteltu auttamaan sijoittajia pääsemään käsiksi ja hyödyntämään korkealaatuisia kaupankäyntimahdollisuuksia kryptovaluuttamarkkinoilla. Kehittynyt rahoitusteknologiamme yhdistää yli 15 teknistä analyysityökalua auttaakseen kauppiaita tunnistamaan optimaaliset sisään- ja ulostulohinnat kaupankäynnissä suosikkikryptovaluutoillaan verkossa. 

Uusi [website_title] tukee laajempaa valikoimaa kryptovaluuttoja, mikä tarjoaa enemmän vaihtoehtoja kaupankäyntiin. Olitpa kiinnostunut Bitcoinista, Ethereumista tai muista suosituista kryptovaluutoista, voit käydä niillä kauppaa uudessa [website_title] -sovelluksessa.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>



        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - Kehittyneet kaupankäyntialgoritmit" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Kehittyneet kaupankäyntialgoritmit')}}</h3>
                    </div>
<div class="features-list-item-text">
    {{ aiTrans(
        "Kaupankäyntialgoritmimme ovat edistyneempiä kuin koskaan, mikä antaa sinulle mahdollisuuden hyödyntää markkinoiden liikkeitä reaaliajassa. Kehittyneiden koneoppimisalgoritmien avulla [website_title] pystyy analysoimaan markkinadataa ja ennustamaan tulevia hintaliikkeitä, mikä antaa sinulle etulyöntiaseman kaupoissasi.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>

                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - Parannettu käyttöliittymä" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Parannettu käyttöliittymä')}}</h3>
                    </div>
                    <div class="features-list-item-text">
    {{ aiTrans(
        "Olemme täysin uudistaneet käyttöliittymämme, tehden siitä intuitiivisemman ja helpomman käyttää. Olitpa aloittelija tai kokenut kauppias, tulet huomaamaan, että uusi [website_title] on helppo navigoida ja käyttää.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>


                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - Parannettu turvallisuus" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('Parannettu turvallisuus')}}</h3>
                    </div>
                    <div class="features-list-item-text">
    {{ aiTrans(
        "Turvallisuus on ensisijainen prioriteettimme [website_title] -alustalla, ja uusi versio sisältää useita kehittyneitä suojausominaisuuksia varmistaakseen varojesi ja henkilökohtaisten tietojesi turvallisuuden. Alustamme on suojattu SSL-salauksella ja kaksivaiheisella todennuksella, ja käytämme uusimpia tietoturvaprotokollia tietojesi suojaamiseksi.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>


                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("REKISTERÖIDY NYT")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "Miten rekisteröidyt käyttämällä [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                           <div class="step-header-line-text">{{aiTrans('Vaihe Yksi')}}</div>
<div class="step-header-line"></div>
</div>
<h3 class="step-header-line-title">{{aiTrans('Rekisteröinti')}}</h3>
</div>
<div>
    {{ aiTrans(
        "Ensimmäinen vaihe on täyttää rekisteröintilomake, jonka löydät verkkosivustoltamme. Sinua pyydetään antamaan perustiedot, kuten etunimi, sukunimi, sähköpostiosoite ja puhelinnumero. Kun olet vastaanottanut vahvistussähköpostin ja napsauttanut vahvistuslinkkiä, tilisi rekisteröidään ja aktivoidaan. Tämä tarkoittaa, että saat täyden pääsyn kaupankäyntisovellukseen [website_title].",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>

</div>

            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
<div class="step-header-line-text">{{aiTrans('Vaihe Kaksi')}}</div>
<div class="step-header-line"></div>
</div>
<h3 class="step-header-line-title">{{aiTrans('Rahoita tili')}}</h3>
</div>
<div>
    {{ aiTrans(
        "Kun olet aktivoinut uuden tilisi, sinun on talletettava varoja tilillesi. Kaupankäynti vaatii pääomaa, jotta voit ylläpitää positioitasi markkinoilla. Sinun on sijoitettava vähimmäismäärä rahaa suorittaaksesi liiketoimia [website_title] -sovelluksen avulla. Mitä suurempi sijoituksesi on, sitä korkeampi on potentiaalinen tuotto, jonka voit ansaita. Tämä tarkoittaa kuitenkin myös suurempaa tappioriskiä. Aloittelijoita kehotetaan olemaan varovaisia alussa ja sijoittamaan vain vähimmäistalletuksen verran. Tämä antaa sinulle mahdollisuuden oppia markkinoiden perusteet ennen suurempien summien sijoittamista.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</div>

</div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
<div class="step-header-line-text">{{aiTrans('Vaihe Kolme')}}</div>
<div class="step-header-line"></div>
</div>
<h3 class="step-header-line-title">{{aiTrans('Kaupankäynti')}}</h3>
</div>
<div>
    {{ aiTrans(
        "Lopuksi sinun on säädettävä kaupankäynnin parametrit ohjelmistossa. Sovellusta voidaan mukauttaa vastaamaan omaa riskinsietokykyäsi, mieltymyksiäsi ja kaupankäyntitavoitteitasi. Tämä varmistaa, että saat parhaan mahdollisen kaupankäyntikokemuksen. Kun olet määrittänyt kaupankäynnin parametrit, olet valmis aloittamaan liiketoimien tekemisen tehokkaan algoritmimme ja markkina-analyysimme avulla.",
        $locale
    ) }}
</div>

</div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('Rekisteröidy nyt aloittaaksesi')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
<h2 class="faq-title">{{aiTrans('Usein kysytyt kysymykset')}}</h2>
<p class="faq-text">
    {{ aiTrans(
        "Todennäköisesti sinulla on vielä joitakin huolenaiheita siitä, miten kaupankäyntisovelluksemme toimii. Jos olet aloittelija kaupankäynnissä, sinulla on todennäköisesti myös kysymyksiä siitä, miten sinun tulisi aloittaa. Tässä ovat joitakin yleisimpiä kysymyksiä, joita kuulemme kauppiailta.",
        $locale
    ) }}
</p>

<div class="faq-accordion">
    <div class="faq-accordion-item">
        <div class="faq-accordion-title">
            <div class="faq-number">1</div>
            <h3 class="heading">
                {{ aiTrans(
                    "Mikä on uusin versio [website_title]?",
                    $locale,
                    ['website_title' => $website_title],
                ) }}
            </h3>
                    <div class="faq-arrow">+</div>
                </div>
<div class="faq-accordion-wrap">
    <p class="faq-answer">
    {{ aiTrans(
        "Uusi versio [website_title] -sovelluksesta on päivitetty versio suositusta kryptovaluuttakaupankäyntialustasta. Se on suunniteltu tarjoamaan kauppiaille entistä tehokkaampia työkaluja ja ominaisuuksia, jotka auttavat heitä menestymään kryptovaluuttamarkkinoilla.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>

</div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">2</div>
        <h3 class="heading">
            {{ aiTrans(
                "Mitä uusia ominaisuuksia uusin versio tarjoaa [website_title]?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
    {{ aiTrans(
        "Uusi versio [website_title] -sovelluksesta tarjoaa useita uusia ominaisuuksia, kuten edistyneitä riskienhallintatyökaluja, reaaliaikaista markkinadataa, muokattavia kaavioita ja graafeja sekä uutis- ja tapahtuma-analyysejä.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>

    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">3</div>
        <h3 class="heading">
            {{ aiTrans(
                "Onko turvallista käyttää uutta [website_title] versiota?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
    {{ aiTrans(
        "Kyllä, uusi versio [website_title] on turvallinen käyttää. Alusta hyödyntää edistyneitä turvatoimia käyttäjätietojen ja transaktioiden suojaamiseksi, ja asiantuntijatiimimme valvoo alustaa ympäri vuorokauden varmistaakseen sen turvallisuuden ja luotettavuuden.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>

    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">4</div>
        <h3 class="heading">
            {{ aiTrans(
                "Voinko mukauttaa kaupankäyntikokemustani [website_title] -sivuston uudella versiolla?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
        <div class="faq-arrow">+</div>
    </div>
    <div class="faq-accordion-wrap">
        <p class="faq-answer">
    {{ aiTrans(
        "Kyllä, uusi versio [website_title] antaa sinulle mahdollisuuden mukauttaa kaupankäyntikokemustasi, mukaan lukien muokattavat kaaviot ja grafiikat, joiden avulla voit helposti tarkastella markkinadataa ja trendejä.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>

    </div>
</div>
<div class="faq-accordion-item">
    <div class="faq-accordion-title">
        <div class="faq-number">5</div>
        <h3 class="heading">
            {{ aiTrans(
                "Onko uusi versio [website_title] sopiva aloittelijoille?",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
    {{ aiTrans(
        "Kyllä, uusi versio [website_title] sopii aloittelijoille. Alusta on helppokäyttöinen ja selkeä navigoida, ja asiantuntijatiimimme on aina valmis tarjoamaan ohjausta ja tukea kaikentasoisille kauppiaille.",
        $locale,
        ['website_title' => $website_title],
    ) }}
</p>


                </div>
            </div>
        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("Rekisteröidy nyt")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "[website_title] Kohokohdat",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    
                
                    
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="Destaques" class="high-img">
                    
                    
                    <div class="high-text">{{aiTrans('Tyyppi')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('AI-kaupankäyntirobotti')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Destaques" class="high-img">
                    <div class="high-text">{{aiTrans('Sovelluksen kustannukset')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Ilmainen')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="Destaques" class="high-img">
                    <div class="high-text">Maksut</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Ei ole')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="Destaques" class="high-img">
                    <div class="high-text">{{aiTrans('Demotili')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Kyllä')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="Destaques" class="high-img">
                    <div class="high-text">{{aiTrans('Varat')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC, ETH, XRP, DASH ja muita')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="Destaques" class="high-img">
                    <div class="high-text">{{aiTrans('Käyttäjätietojen suojaus')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('Kyllä')}}</div>
                </div>
            </div>
        </div>
        
        
        
        
    </div>
</div>
@endsection
