@extends('layouts.app')

@section('content')
<div class="hero wf-section">
    <div class="container w-container">
        <h1 class="hero-header">{{$website_title}}</h1>
        <h3 class="hero-subtitle">
            {{ aiTrans(
                "إحداث ثورة في تداول العملات المشفرة: تقديم أحدث تحديث لـ $website_title",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h3>
        <div class="main-cols">
            <div class="video-col">
                <img src="dist/images/poster_index.webp" sizes="(max-width: 479px) 100vw, (max-width: 767px) 96vw, (max-width: 991px) 97vw, 62vw" srcset="{{ asset('frontend/assets/pt/dist') }}/images/poster_index-p-500.webp 500w, {{ asset('frontend/assets/pt/dist') }}/images/poster_index.webp 733w" alt="{{$website_title}} - إحداث ثورة في تداول العملات المشفرة: تقديم أحدث تحديث لـ {{$website_title}}" width="710" height="399" class="main-image"></div>
            <div class="form-col">
                <div class="form-container">
                    <div id="formTop" class="form-box w-form-wrapper">
                        @include('frontend.ar.components.form')
                        <div class="w-form-done">
                            <div>{{aiTrans('شكرًا! تم استلام طلبك بنجاح!', $locale)}}</div>
                        </div>
                        <div class="w-form-fail">
                            <div>{{aiTrans('عفوًا! حدث خطأ أثناء إرسال النموذج.', $locale)}}</div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="hero-bg-2"></div>
    <div class="hero-bg-1"></div>
</div>
<div class="trading w-clearfix wf-section">
<img loading="lazy" 
     src="{{ asset('frontend/assets/pt/dist') }}/images/trade-image.webp" 
     width="200" 
     height="400" 
     alt="{{$website_title}} - O que é o {{$website_title}}?" 
     class="img-float-right no-float-on-991">
    <div class="container w-container">
        <h2 class="trading-title">
            {{ aiTrans(
"ما هو [website_title]؟",
$locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="trading-text">
            {{ aiTrans(
                "يسرنا أن نعلن عن إطلاق الإصدار الجديد من [website_title] – المنصة النهائية لتداول العملات الرقمية. مع ميزات متقدمة، وتكنولوجيا حديثة، وواجهة سهلة الاستخدام، تم تصميم [website_title] الجديد للارتقاء بتجربة التداول الخاصة بك إلى المستوى التالي.

البرنامج القوي والبديهي للتداول قادر على استغلال الفروق الصغيرة في أسعار العملات الرقمية بين البورصات المختلفة. بعد ذلك، سيقوم بشراء العملات الرقمية بسعر منخفض ثم بيعها بسعر أعلى. والنتيجة النهائية هي تحقيق أرباح صغيرة تتراكم لتصبح أرباحًا كبيرة للمستخدم.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button margin-bottom-35 w-button">{{aiTrans("سجل الآن")}}</a>
        </div>
        <h2 class="trading-title">{{aiTrans('كيف يمكنني البدء في التداول عبر الإنترنت؟')}}</h2>
        <div class="trading-text">{{aiTrans('يعد التداول عبر الإنترنت، أي عملية شراء وبيع الأصول المالية عبر الإنترنت، أمرًا يمكن لأي شخص القيام به بغض النظر عن خبرته السابقة في الأسواق المالية العالمية. على الرغم من أن البدء يبدو سهلاً، إلا أن تحقيق الأرباح من خلال التداول عبر الإنترنت قد يكون تحديًا حقيقيًا.

لبدء التداول عبر الإنترنت، ستحتاج إلى جهاز كمبيوتر واتصال إنترنت موثوق. بعد تسجيل حساب تداول في منصة موثوقة، يمكنك بدء التداول بمجرد تنشيط حسابك وتمويله.

ومن المثير للاهتمام أنه على الرغم من سهولة البدء في التداول، إلا أن تحقيق النجاح كتاجر يعد أمرًا أكثر صعوبة. هناك العديد من المخاطر التي يجب أن تكون على دراية بها. يعتمد التداول بشكل كبير على التخطيط المنهجي، والتحليل الدقيق للأسواق، وفهم العوامل التي تؤثر على أسعار الأصول، بالإضافة إلى التجربة والخطأ.

بعض الأسواق قد تكون شديدة التقلب، مما قد يزيد من مخاطر الخسارة إذا لم تكن لديك المهارات الكافية للاستفادة من الفرص المربحة التي يمكن أن توفرها هذه التقلبات.

على الرغم من هذه التحديات، فإن التقدم في التكنولوجيا، وخاصة في أنظمة التداول الخوارزمية، جعل من السهل أكثر من أي وقت مضى بدء التداول عبر الإنترنت بدقة أكبر. يقوم خوارزمية التطبيق بتحليل الأسواق لتحديد فرص التداول، وبناءً على هذه المعلومات، يمكنك اتخاذ قرارات تداول أكثر ذكاءً بناءً على التحليل السوقي. وبهذه الطريقة، حتى المتداولين المبتدئين يمكنهم البدء في تداول أصولهم المفضلة عبر الإنترنت.')}}</div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("سجل الآن")}}</a>
            <div class="trading-bg2"></div>
        </div>
    </div>
    <div class="trading-bg-1"></div>
</div>
<div class="improve-your-trading w-clearfix wf-section">
<img loading="lazy" 
     src="{{ asset('frontend/assets/pt/dist') }}/images/improve-your-trading-img.webp" 
     alt="{{$website_title}} - كيف يتم التطبيق {{$website_title}} تحسين التداول الخاص بك?" 
     class="img-float-right improve-your-trading-img"
     width="200" height="400">
    <div class="container w-container">
        <h2 class="improve-your-trading-title">
            {{ aiTrans(
                "كيف يُحسّن تطبيق [website_title] تجربة التداول الخاصة بك؟",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="improve-your-trading-text">
            {{ aiTrans(
                "لا يهم مستوى مهارتك في التداول عبر الإنترنت، حيث يمكنك الاستفادة من الميزات القوية التي يوفرها تطبيق [website_title]. ولكن أولاً، تحتاج إلى فهم كيفية عمل البرنامج.

يتمتع [website_title] بقدرة على تحليل الأسواق باستخدام خوارزمية متقدمة للغاية، والتي تدمج كميات هائلة من بيانات السوق بالإضافة إلى بعض المؤشرات التقنية الهامة لتحديد فرص التداول ذات الاحتمالية العالية.

يمكنك أيضًا ضبط الإعدادات في واجهة البرنامج سهلة الاستخدام، حيث يمكنك تعديل طريقة عمله وفقًا لمستوى مهاراتك، وتحملك للمخاطر، وتفضيلاتك الشخصية. يمكّن البرنامج حتى المتداولين المبتدئين من الدخول إلى الأسواق دون القلق بشأن ارتكاب الأخطاء أثناء تحليل تحركات الأسعار ومعرفة متى يجب عليهم الدخول في الصفقات.

إضافةً إلى ذلك، من أهم ميزات التطبيق أنه كلما تطورت مهاراتك في التداول، قد ترغب في تبني نهج أكثر تحكمًا. في هذه الحالة، لا يزال البرنامج مفيدًا جدًا، حيث يمكنك استخدامه لتأكيد تحليلك الخاص للسوق قبل الدخول في أي صفقة.

حتى على مستوى مهارة عالٍ، قد تجد نفسك في مواقف تكون فيها متوترًا أو متحمسًا للغاية لاتخاذ قرارات تداول منطقية. في مثل هذه الحالات، يمكنك الاستفادة من التحليل السوقي الذي يوفره التطبيق، مما يساعدك على تجنب الوقوع في خطأ التداول العاطفي، ويضمن أن قراراتك تستند إلى بيانات السوق الفعلية.

إحدى أفضل ميزات [website_title] هي أنه يمكنك تسجيل حساب جديد مجانًا تمامًا. قم بالتسجيل الآن وابدأ التداول في الأسواق!",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans('افتح حسابًا مجانيًا الآن')}}</a>
        </div>
        <div class="improve-your-trading-bg"></div>
    </div>
    <div class="improve-your-trading-bg-2"></div>
</div>
<div class="features wf-section">
    <div class="container w-container">
        <div class="features-bg"></div>
        <h2 class="features-title">
            {{ aiTrans(
                "الميزات الرئيسية لـ [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="features-text">
            {{ aiTrans(
                "[website_title] هو الإصدار الأحدث من تطبيق التداول القوي الخاص بنا، المصمم لمساعدة المستثمرين على الوصول إلى والاستفادة القصوى من الفرص التجارية عالية الجودة في أسواق العملات الرقمية.

تجمع تقنياتنا المالية المتقدمة بين أكثر من 15 أداة تحليل فني لمساعدة المتداولين في تحديد نقاط الدخول والخروج المثالية عند تداول عملاتهم الرقمية المفضلة عبر الإنترنت.

يدعم الإصدار الجديد من [website_title] مجموعة أوسع من العملات الرقمية، مما يمنحك المزيد من الخيارات عند التداول. سواء كنت مهتمًا بالبيتكوين أو الإيثريوم أو غيرها من العملات الرقمية الشهيرة، يمكنك تداولها بسهولة باستخدام [website_title] الجديد.",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </div>
        <div class="features-list w-row">
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature1-icon.webp" alt="{{$website_title}} - خوارزميات تداول متقدمة" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('خوارزميات تداول متقدمة')}}</h3>
                    </div>
                    <div class="features-list-item-text">{{aiTrans('خوارزميات التداول لدينا أصبحت أكثر تطورًا من أي وقت مضى، مما يتيح لك الاستفادة من تحركات السوق في الوقت الفعلي.

باستخدام خوارزميات متقدمة تعتمد على تعلم الآلة، يمكن لـ [website_title] تحليل بيانات السوق وإجراء توقعات حول تحركات الأسعار المستقبلية، مما يمنحك ميزة في صفقاتك.', $locale , ['website_title' => $website_title])}}</div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature2-icon.webp" alt="{{$website_title}} - واجهة مستخدم محسّنة" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('واجهة مستخدم محسّنة')}}</h3>
                    </div>
                    <div class="features-list-item-text">

                        {{ aiTrans(
                            "لقد أعدنا تصميم واجهة المستخدم بالكامل، مما يجعلها أكثر سهولة وبديهية في الاستخدام.

سواء كنت مبتدئًا أو متداولًا متمرسًا، ستجد أن [website_title] الجديد سهل التنقل والاستخدام.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="w-col w-col-4 w-col-stack">
                <div class="features-list-item">
                    <div class="features-list-item-header">
                        <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/feature3-icon.webp" alt="{{$website_title}} - أمان محسّن" class="features-list-item-header-icon">
                        <h3 class="features-list-item-header-title">{{aiTrans('أمان محسّن')}}</h3>
                    </div>
                    <div class="features-list-item-text">
                        {{ aiTrans(
                            "الأمان هو أولويتنا القصوى في [website_title]، ويتضمن النظام الأساسي الجديد مجموعة متنوعة من ميزات الأمان المتقدمة للحفاظ على أموالك ومعلوماتك الشخصية آمنة.

منصتنا محمية بتقنية تشفير SSL وميزة المصادقة الثنائية، كما أننا نستخدم أحدث بروتوكولات الأمان لضمان حماية بياناتك.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
        </div>
        <div class="button-wrapper margin-0-auto">
            <a href="#formTop" class="button w-button">{{aiTrans("سجل الآن")}}</a>
        </div>
    </div>
    <div class="featues-bg-1"></div>
</div>
<div class="steps wf-section">
    <div class="container w-container">
        <h2 class="steps-title">
            {{ aiTrans(
                "كيف يمكنك التسجيل في [website_title]؟",
                $locale,
                ['website_title' => $website_title],
            ) }}
            </h2>
        <div class="steps-list w-row">
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('الخطوة الأولى')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('التسجيل')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "الخطوة الأولى هي ملء نموذج التسجيل الذي يمكنك العثور عليه على موقعنا الإلكتروني. سيتم طلب بعض المعلومات الأساسية منك، مثل الاسم، اللقب، عنوان البريد الإلكتروني، ورقم الهاتف.

بعد استلامك رسالة التأكيد عبر البريد الإلكتروني والنقر على رابط التفعيل، سيتم تسجيلك وتفعيل حسابك الجديد. وهذا يعني أنك ستحصل على وصول كامل إلى تطبيق التداول [website_title].",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('الخطوة الثانية')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('التمويل')}}</h3>
                    </div>
                    <div>
                        {{ aiTrans(
                            "بعد تفعيل حسابك الجديد، ستحتاج إلى إيداع أموال في حسابك. يتطلب التداول رأس مال للحفاظ على مراكزك في السوق.

ستكون مطالبًا باستثمار حد أدنى من المال لإجراء الصفقات باستخدام تطبيق [website_title]. كلما زاد استثمارك، زادت فرص تحقيق الأرباح المحتملة، ولكن هذا يعني أيضًا زيادة خطر الخسارة.

يُنصح المبتدئون بالبدء بحذر والاستثمار فقط بالمبلغ الأدنى المطلوب للإيداع. سيمكنك ذلك من تعلم أساسيات الأسواق المالية قبل استثمار مبالغ أكبر من الأموال.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </div>
                </div>
            </div>
            <div class="col w-col w-col-4 w-col-stack">
                <div class="step-item">
                    <div class="step-header">
                        <div class="step-header-line-wrapper">
                            <div class="step-header-line-text">{{aiTrans('الخطوة الثالثة')}}</div>
                            <div class="step-header-line"></div>
                        </div>
                        <h3 class="step-header-line-title">{{aiTrans('التداول')}}</h3>
                    </div>
                    <div>{{aiTrans('أخيرًا، ستحتاج إلى ضبط معايير التداول في البرنامج. يمكن تخصيص التطبيق ليتناسب مع مستوى تحملك للمخاطر، تفضيلاتك، وأهدافك في التداول، مما يضمن حصولك على أفضل تجربة ممكنة.

بمجرد الانتهاء من إعداد معايير التداول الخاصة بك، ستكون جاهزًا لبدء تنفيذ الصفقات باستخدام الخوارزمية القوية والتحليل السوقي المتقدم الذي يقدمه التطبيق.')}}</div>
                </div>
            </div>
        </div>
        <div class="button-wrapper steps-action-button">
            <a href="#formTop" class="button white w-button">{{aiTrans('سجّل الآن للبدء')}}</a>
        </div>
    </div>
</div>
<div class="faq wf-section">
    <div class="container w-container">
        <h2 class="faq-title">{{aiTrans('الأسئلة الشائعة')}}</h2>
        <p class="faq-text">{{aiTrans('من المحتمل جدًا أن لا تزال لديك بعض التساؤلات حول كيفية عمل تطبيق التداول الخاص بنا.

إذا كنت متداولًا مبتدئًا، فمن المحتمل أن يكون لديك أيضًا أسئلة حول كيفية البدء.

فيما يلي بعض الأسئلة الأكثر شيوعًا التي نتلقاها من المتداولين.')}}</p>
        <div class="faq-accordion">
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">1</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "ما هو الإصدار الجديد من [website_title]؟",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "الإصدار الجديد من [website_title] هو نسخة محدثة من منصة التداول الشهيرة للعملات الرقمية، تم تصميمه لتزويد المتداولين بأدوات وميزات أكثر قوة لمساعدتهم على تحقيق النجاح في سوق العملات الرقمية.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                        </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">2</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "ما هي الميزات الجديدة التي يوفرها الإصدار الجديد من [website_title]؟",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "يقدم الإصدار الجديد من [website_title] مجموعة متنوعة من الميزات الجديدة، بما في ذلك أدوات متقدمة لإدارة المخاطر، وبيانات سوقية في الوقت الفعلي، وجداول ورسوم بيانية قابلة للتخصيص، بالإضافة إلى تحليل الأخبار والأحداث.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">3</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "هل الإصدار الجديد من [website_title] آمن للاستخدام؟",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "نعم، الإصدار الجديد من [website_title] آمن للاستخدام. تستخدم المنصة تدابير أمنية متقدمة لحماية بيانات المستخدم ومعاملاته، كما تراقب فرقنا المختصة المنصة على مدار الساعة طوال أيام الأسبوع لضمان أمانها وموثوقيتها.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">4</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "هل يمكنني تخصيص تجربة التداول الخاصة بي مع الإصدار الجديد من [website_title]؟",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "نعم، يتيح لك الإصدار الجديد من [website_title] تخصيص تجربة التداول الخاصة بك، بما في ذلك الجداول والرسوم البيانية القابلة للتخصيص التي تسهل عرض بيانات السوق والاتجاهات بسهولة.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>
            <div class="faq-accordion-item">
                <div class="faq-accordion-title">
                    <div class="faq-number">5</div>
                    <h3 class="heading">
                        {{ aiTrans(
                            "هل الإصدار الجديد من [website_title] مناسب للمبتدئين؟",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </h3>
                    <div class="faq-arrow">+</div>
                </div>
                <div class="faq-accordion-wrap">
                    <p class="faq-answer">
                        {{ aiTrans(
                            "نعم، الإصدار الجديد من [website_title] مناسب للمبتدئين. تتميز المنصة بسهولة الاستخدام والتنقل، كما أن فريقنا المختص متاح لتقديم التوجيه والدعم للمتداولين من جميع مستويات الخبرة.",
                            $locale,
                            ['website_title' => $website_title],
                        ) }}
                    </p>
                </div>
            </div>

        </div>
        <div class="button-wrapper">
            <a href="#formTop" class="button w-button">{{aiTrans("سجل الآن")}}!</a>
        </div>
    </div>
    <div class="faq-bg-2"></div>
    <div class="faq-bg-3"></div>
</div>
<div class="highlights-section wf-section">
    <div class="container w-container">
        <h2 class="faq-title">
            {{ aiTrans(
                "أبرز ميزات [website_title]",
                $locale,
                ['website_title' => $website_title],
            ) }}
        </h2>
        <div class="high-table">
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-1.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('النوع')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('روبوت تداول بالذكاء الاصطناعي')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('تكلفة التطبيق')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('مجاني')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-3.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('الرسوم')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('لا يوجد')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-4.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('حساب تجريبي')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('نعم')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-2.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('الأصول')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('BTC، ETH، XRP، DASH وغيرها')}}</div>
                </div>
            </div>
            <div class="tr">
                <div class="td w-clearfix">
                    <img loading="lazy" src="{{ asset('frontend/assets/pt/dist') }}/images/highlight-6.webp" alt="أبرز الميزات" class="high-img">
                    <div class="high-text">{{aiTrans('حماية بيانات المستخدم')}}</div>
                </div>
                <div class="td">
                    <div class="high-text">{{aiTrans('نعم')}}</div>
                </div>
            </div>
        </div>
    </div>

</div>
@endsection
