<?php

namespace Codebase\PageBuilder\Models;

use App\Support\Concerns\HasFactory;
use Codebase\PageBuilder\Concerns\Editable;
use Codebase\PageBuilder\Concerns\InteractWithEditablePage;
use Illuminate\Database\Eloquent\Model;

class EditablePage extends Model implements Editable
{
    use HasFactory, InteractWithEditablePage;

    protected $guarded = [];

    public function editable()
    {
        return $this->morphTo('editable');
    }
}
