<?php

namespace Codebase\PageBuilder\Datatables;

use \App\Support\Dashboard\Datatables\BaseDatatable;
use Blade;
use Codebase\PageBuilder\Models\StaticPage;
use File;
use Illuminate\Database\Eloquent\Builder;
use Yajra\DataTables\Html\Column;

class StaticPageDatatable extends BaseDatatable
{
    protected ?string $actionable = 'showItem|editItem|deleteItem';

    public function query(): Builder
    {
        return StaticPage::query();
    }

    protected function columns(): array
    {
        return [
            Column::make('name.'.app()->getLocale())->title(__('Name')),
            Column::make('updated_at')->title(__('Last Update')),
        ];
    }

    protected function customColumns(): array
    {
        return [
            'updated_at' => function ($model) {
                return $model->updated_at->toDayDateTimeString();
            },
        ];
    }


    protected function orders(): array
    {
        return [
            'name.ar'  => fn ($i, $k) => $i->orderBy('name', $k),
            'name.en'  => fn ($i, $k) => $i->orderBy('name', $k),
        ];
    }

    protected function filters(): array
    {
        return [
            'name.ar' => fn ($i, $k) => $i->where('name', 'like', "%$k%"),
            'name.en' => fn ($i, $k) => $i->where('name', 'like', "%$k%"),
        ];
    }


    protected function actions($model): array
    {
        return [
            "showItem" => Blade::render(File::get(app_path('Support/Dashboard/Datatables/actions/show_button.blade.php')), [
                'route' => route($this->route . '.show', ['staticPage' => $model->id ]),
            ]),
            "editItem" => !$model->is_section ?  (Blade::render(File::get(app_path('Support/Dashboard/Datatables/actions/edit_button.blade.php')), [
                'route' => route($this->route . '.edit', ['staticPage' => $model->id ]),
                ]) ) : null,
            "deleteItem" => !$model->main_page ? (Blade::render(File::get(app_path('Support/Dashboard/Datatables/actions/delete_button.blade.php')), [
                'route' => route($this->route . '.destroy', ['staticPage' => $model->id])  ,
            ]) ) : null,

        ];
    }


    
}
