<?php

namespace App\Support\HsmFireBase;

use Illuminate\Support\Facades\Http;

class FireBase
{
    private const API_TOKEN = 'AAAAa_3xNZk:APA91bFYEAg892jKuUJ_h0gZamdn8Z5qf0ybWFFLfQ7oRww3HxzLVd265WhkTdkurFR6VeWiLyUZHQptSqxqyFskxFHBedxxG6iMPkFy5tqiO-M4vN7vN3yYKrbhZAwAbQ7IBdDpauIR';

    public static function send(FireBaseModel $model): bool
    {
        $result = self::usingTokens($model->androidTokens, $model->toData());
        $result &= self::usingTokens($model->iosTokens, $model->toMessage(), true);

        return $result;
    }

    public static function usingTokens(
        array $tokens,
        array $data,
        bool  $notification = false
    ): bool
    {

        if (count($tokens) === 0) {
            return false;
        }
        $request = [
            'registration_ids' => $tokens,
            'priority' => 'high',
            $notification ? 'notification' : 'data' => $data,
        ];

        return self::makeRequest($request);
    }


    public static function usingTopic(string $topic, $title, $body): bool
    {

        $model = new FireBaseModel($topic, $title, $body);

        $request = [
            'to' => '/topics/' . $topic,
            'notification' => $model->toMessage(),
            'data' => $model->toData(),
        ];

        return self::makeRequest($request);
    }

    public static function makeRequest(array $data, bool $debug = false): bool
    {
        $client = Http::withHeaders([
            'Authorization' => 'key=' . self::API_TOKEN,
            'Content-Type' => ' application/json',
        ])->post('https://fcm.googleapis.com/fcm/send', $data);

        $debug && info('firebase: ' . $client->body());

        return $client->ok();
    }
}
